<?php
// Script para configurar la tabla de derivaciones si no existe
session_start();

require_once('../../model/conexion.php');

echo "<h1>Configuración de Tabla Derivaciones</h1>";

try {
    $conexion = new Conexion();
    $conexion->conectar();
    echo "<p style='color: green;'>✅ Conexión a la base de datos exitosa</p>";
    
    // Verificar si la tabla derivaciones existe
    $consultaTabla = "SHOW TABLES LIKE 'derivaciones'";
    $resultadoTabla = $conexion->query($consultaTabla);
    
    if ($resultadoTabla && $resultadoTabla->num_rows > 0) {
        echo "<p style='color: green;'>✅ La tabla 'derivaciones' ya existe</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ La tabla 'derivaciones' no existe. Creándola...</p>";
        
        $crearTabla = "CREATE TABLE derivaciones (
            id INT AUTO_INCREMENT PRIMARY KEY,
            study_instance_uid VARCHAR(255) NOT NULL,
            usuario_origen_id INT NOT NULL,
            usuario_destino_id INT NOT NULL,
            fecha_derivacion DATETIME DEFAULT CURRENT_TIMESTAMP,
            activo TINYINT(1) DEFAULT 1,
            comentario TEXT,
            vista TINYINT(1) DEFAULT 0,
            descargada TINYINT(1) DEFAULT 0,
            fecha_vista DATETIME NULL,
            fecha_descarga DATETIME NULL,
            INDEX idx_usuario_origen (usuario_origen_id),
            INDEX idx_usuario_destino (usuario_destino_id),
            INDEX idx_study_uid (study_instance_uid),
            INDEX idx_activo (activo)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        
        if ($conexion->query($crearTabla)) {
            echo "<p style='color: green;'>✅ Tabla 'derivaciones' creada exitosamente</p>";
        } else {
            echo "<p style='color: red;'>❌ Error al crear tabla: " . $conexion->error() . "</p>";
            exit;
        }
    }
    
    // Verificar si hay datos en la tabla
    $consultaConteo = "SELECT COUNT(*) as total FROM derivaciones";
    $resultadoConteo = $conexion->query($consultaConteo);
    
    if ($resultadoConteo) {
        $conteo = $resultadoConteo->fetch_assoc();
        echo "<p><strong>Total de registros en derivaciones:</strong> " . $conteo['total'] . "</p>";
        
        if ($conteo['total'] == 0) {
            echo "<p style='color: orange;'>⚠️ No hay datos en la tabla. Insertando datos de prueba...</p>";
            
            // Verificar que existan usuarios para las pruebas
            $consultaUsuarios = "SELECT id, nombre FROM usuarios LIMIT 3";
            $resultadoUsuarios = $conexion->query($consultaUsuarios);
            
            if ($resultadoUsuarios && $resultadoUsuarios->num_rows >= 2) {
                $usuarios = [];
                while ($usuario = $resultadoUsuarios->fetch_assoc()) {
                    $usuarios[] = $usuario;
                }
                
                // Insertar datos de prueba con usuarios reales
                $insertarPrueba = "INSERT INTO derivaciones (study_instance_uid, usuario_origen_id, usuario_destino_id, comentario, activo) VALUES 
                    ('1.2.3.4.5.6.7.8.9.10.1', " . $usuarios[0]['id'] . ", " . $usuarios[1]['id'] . ", 'Derivación de prueba 1 - Admin a Usuario', 1),
                    ('1.2.3.4.5.6.7.8.9.10.2', " . $usuarios[1]['id'] . ", " . $usuarios[0]['id'] . ", 'Derivación de prueba 2 - Usuario a Admin', 1)";
                
                if (count($usuarios) >= 3) {
                    $insertarPrueba .= ",('1.2.3.4.5.6.7.8.9.10.3', " . $usuarios[0]['id'] . ", " . $usuarios[2]['id'] . ", 'Derivación de prueba 3 - Admin a Usuario 2', 1)";
                }
                
                if ($conexion->query($insertarPrueba)) {
                    echo "<p style='color: green;'>✅ Datos de prueba insertados exitosamente</p>";
                    echo "<p>Usuarios utilizados:</p>";
                    echo "<ul>";
                    foreach ($usuarios as $usuario) {
                        echo "<li>ID: " . $usuario['id'] . " - Nombre: " . $usuario['nombre'] . "</li>";
                    }
                    echo "</ul>";
                } else {
                    echo "<p style='color: red;'>❌ Error al insertar datos: " . $conexion->error() . "</p>";
                }
            } else {
                echo "<p style='color: red;'>❌ No hay suficientes usuarios en la tabla para crear datos de prueba</p>";
            }
        }
    }
    
    // Mostrar datos actuales
    echo "<h2>Datos actuales en la tabla derivaciones:</h2>";
    $consultaDatos = "SELECT d.*, 
                      u_origen.nombre as origen_nombre, 
                      u_destino.nombre as destino_nombre 
                      FROM derivaciones d 
                      LEFT JOIN usuarios u_origen ON d.usuario_origen_id = u_origen.id 
                      LEFT JOIN usuarios u_destino ON d.usuario_destino_id = u_destino.id 
                      ORDER BY d.fecha_derivacion DESC";
    
    $resultadoDatos = $conexion->query($consultaDatos);
    
    if ($resultadoDatos && $resultadoDatos->num_rows > 0) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0; width: 100%;'>";
        echo "<tr><th>ID</th><th>Study UID</th><th>De</th><th>Para</th><th>Fecha</th><th>Comentario</th><th>Activo</th><th>Vista</th><th>Descargada</th></tr>";
        while ($derivacion = $resultadoDatos->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $derivacion['id'] . "</td>";
            echo "<td>" . substr($derivacion['study_instance_uid'], 0, 30) . "...</td>";
            echo "<td>" . ($derivacion['origen_nombre'] ?: 'ID: ' . $derivacion['usuario_origen_id']) . "</td>";
            echo "<td>" . ($derivacion['destino_nombre'] ?: 'ID: ' . $derivacion['usuario_destino_id']) . "</td>";
            echo "<td>" . $derivacion['fecha_derivacion'] . "</td>";
            echo "<td>" . ($derivacion['comentario'] ?: 'Sin comentario') . "</td>";
            echo "<td>" . ($derivacion['activo'] ? 'Sí' : 'No') . "</td>";
            echo "<td>" . ($derivacion['vista'] ? 'Sí' : 'No') . "</td>";
            echo "<td>" . ($derivacion['descargada'] ? 'Sí' : 'No') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No hay datos para mostrar</p>";
    }
    
    $conexion->cerrar();
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='index.php'>← Volver a admin/index.php</a></p>";
echo "<p><a href='test_derivaciones.php'>🔍 Ejecutar diagnóstico completo</a></p>";
?>