<?php
session_start();
if(!isset($_SESSION['cargo']) || $_SESSION['cargo'] != 1){
    header('location: ../../index.php');
    exit();
}

$studyInstanceUID = $_GET['study'] ?? '';
if (empty($studyInstanceUID)) {
    die("ID de estudio no proporcionado");
}

// Función para obtener información del estudio
function obtenerInfoEstudio($studyInstanceUID) {
    $url = "https://iset.portalpaciente.com.ar/api/find";
    $data = json_encode([
        "Level" => "Study",
        "Query" => [
            "StudyInstanceUID" => $studyInstanceUID
        ],
        "Expand" => true
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        error_log('Error cURL en obtenerInfoEstudio: ' . curl_error($ch));
        curl_close($ch);
        return null;
    }
    
    curl_close($ch);
    
    $jsonData = json_decode($response, true);
    
    if ($jsonData && count($jsonData) > 0) {
        $study = $jsonData[0];
        return [
            'patientName' => str_replace("^", " ", $study['PatientMainDicomTags']['PatientName'] ?? ''),
            'studyID' => $study['ID'] ?? ''
        ];
    }
    
    return null;
}

// Obtener información del estudio
$infoEstudio = obtenerInfoEstudio($studyInstanceUID);

if (!$infoEstudio || empty($infoEstudio['studyID'])) {
    die("Error: No se pudo obtener la información del estudio");
}

$studyID = $infoEstudio['studyID'];
$patientName = $infoEstudio['patientName'];
$safePatientName = preg_replace('/[^a-zA-Z0-9_-]/', '_', $patientName);

// URL para la descarga del archivo usando API de Orthanc
$downloadUrl = "https://iset.portalpaciente.com.ar/api/studies/{$studyID}/archive?filename={$safePatientName}.zip";

// Redirigir al usuario directamente a la URL de descarga
header("Location: " . $downloadUrl);
exit();
?>
