<?php
session_start();

// Validamos que exista una session y ademas que el cargo que exista sea igual a 0 (Root) o 1 (Administradores)
if(!isset($_SESSION['cargo']) || ($_SESSION['cargo'] != '0' && $_SESSION['cargo'] != '1')){
    header('location: ../index.php');
    exit();
}

// Importar la clase Conexion
require_once('../model/conexion.php');

// Verificar que la solicitud sea POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

// Obtener la acción
$action = $_POST['action'] ?? '';

try {
    $conexion = new Conexion();
    $conexion->conectar();
    
    switch ($action) {
        case 'create':
            // Crear nuevo usuario
            $nombre = $conexion->salvar($_POST['nombre'] ?? '');
            $email = $conexion->salvar($_POST['email'] ?? '');
            $clave = $conexion->salvar($_POST['clave'] ?? '');
            $cargo = $conexion->salvar($_POST['cargo'] ?? '2');
            
            // Validaciones
            if (empty($nombre) || empty($email) || empty($clave)) {
                echo json_encode(['success' => false, 'message' => 'Todos los campos son requeridos']);
                exit();
            }
            
            // Validar email
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                echo json_encode(['success' => false, 'message' => 'Email inválido']);
                exit();
            }
            
            // Validar que el email no exista
            $verificarEmail = $conexion->verificarRegistros("SELECT id FROM usuarios WHERE email = '$email'");
            
            if ($verificarEmail > 0) {
                echo json_encode(['success' => false, 'message' => 'El correo electrónico ya existe en el sistema']);
                exit();
            }
            
            // Crear usuario
            $claveHash = md5($clave);
            $query = "INSERT INTO usuarios (nombre, email, clave, cargo) VALUES ('$nombre', '$email', '$claveHash', '$cargo')";
            
            if ($conexion->query($query)) {
                echo json_encode(['success' => true, 'message' => 'Usuario creado exitosamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al crear el usuario: ' . $conexion->error()]);
            }
            break;
            
        case 'update':
            // Actualizar usuario
            $id = $conexion->salvar($_POST['id'] ?? '');
            $nombre = $conexion->salvar($_POST['nombre'] ?? '');
            $email = $conexion->salvar($_POST['email'] ?? '');
            $cargo = $conexion->salvar($_POST['cargo'] ?? '2');
            
            // Validaciones
            if (empty($id) || empty($nombre) || empty($email)) {
                echo json_encode(['success' => false, 'message' => 'Todos los campos son requeridos']);
                exit();
            }
            
            // Validar email
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                echo json_encode(['success' => false, 'message' => 'Email inválido']);
                exit();
            }
            
            // Verificar si el usuario a actualizar es root y si el usuario actual tiene permisos
            $resultadoUsuario = $conexion->query("SELECT cargo FROM usuarios WHERE id = '$id'");
            if ($resultadoUsuario && $resultadoUsuario->num_rows > 0) {
                $usuarioAActualizar = $resultadoUsuario->fetch_assoc();
                if ($usuarioAActualizar['cargo'] == '0' && $_SESSION['cargo'] != '0') {
                    echo json_encode(['success' => false, 'message' => 'No tienes permisos para editar usuarios root']);
                    exit();
                }
            }
            
            // Verificar si el email ya existe en otro usuario
            $verificarEmail = $conexion->verificarRegistros("SELECT id FROM usuarios WHERE email = '$email' AND id != '$id'");
            
            if ($verificarEmail > 0) {
                echo json_encode(['success' => false, 'message' => 'El correo electrónico ya existe en otro usuario']);
                exit();
            }
            
            // Actualizar usuario
            $query = "UPDATE usuarios SET nombre = '$nombre', email = '$email', cargo = '$cargo' WHERE id = '$id'";
            
            if ($conexion->query($query)) {
                echo json_encode(['success' => true, 'message' => 'Usuario actualizado exitosamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar el usuario: ' . $conexion->error()]);
            }
            break;
            
        case 'delete':
            // Eliminar usuario
            $id = $conexion->salvar($_POST['id'] ?? '');
            
            if (empty($id)) {
                echo json_encode(['success' => false, 'message' => 'ID de usuario requerido']);
                exit();
            }
            
            // No permitir eliminar el usuario actual
            if ($id == $_SESSION['id']) {
                echo json_encode(['success' => false, 'message' => 'No puedes eliminar tu propia cuenta']);
                exit();
            }
            
            // Verificar si el usuario a eliminar es root y si el usuario actual tiene permisos
            $resultadoUsuario = $conexion->query("SELECT cargo FROM usuarios WHERE id = '$id'");
            if ($resultadoUsuario && $resultadoUsuario->num_rows > 0) {
                $usuarioAEliminar = $resultadoUsuario->fetch_assoc();
                if ($usuarioAEliminar['cargo'] == '0' && $_SESSION['cargo'] != '0') {
                    echo json_encode(['success' => false, 'message' => 'No tienes permisos para eliminar usuarios root']);
                    exit();
                }
            }
            
            // Eliminar usuario
            $query = "DELETE FROM usuarios WHERE id = '$id'";
            
            if ($conexion->query($query)) {
                echo json_encode(['success' => true, 'message' => 'Usuario eliminado exitosamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar el usuario: ' . $conexion->error()]);
            }
            break;
            
        case 'reset_password':
            // Resetear contraseña
            $id = $conexion->salvar($_POST['id'] ?? '');
            $nuevaClave = $conexion->salvar($_POST['nueva_clave'] ?? '');
            
            if (empty($id) || empty($nuevaClave)) {
                echo json_encode(['success' => false, 'message' => 'ID de usuario y nueva contraseña requeridos']);
                exit();
            }
            
            // Verificar si el usuario a resetear es root y si el usuario actual tiene permisos
            $resultadoUsuario = $conexion->query("SELECT cargo FROM usuarios WHERE id = '$id'");
            if ($resultadoUsuario && $resultadoUsuario->num_rows > 0) {
                $usuarioAResetear = $resultadoUsuario->fetch_assoc();
                if ($usuarioAResetear['cargo'] == '0' && $_SESSION['cargo'] != '0') {
                    echo json_encode(['success' => false, 'message' => 'No tienes permisos para resetear la contraseña de usuarios root']);
                    exit();
                }
            }
            
            // Actualizar contraseña
            $claveHash = md5($nuevaClave);
            $query = "UPDATE usuarios SET clave = '$claveHash' WHERE id = '$id'";
            
            if ($conexion->query($query)) {
                echo json_encode(['success' => true, 'message' => 'Contraseña actualizada exitosamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar la contraseña: ' . $conexion->error()]);
            }
            break;
            
        case 'list':
            // Listar usuarios
            $query = "SELECT id, nombre, email, cargo, 
                      CASE 
                        WHEN cargo = '0' THEN 'Root'
                        WHEN cargo = '1' THEN 'Administrador'
                        WHEN cargo = '2' THEN 'Usuario'
                        ELSE 'Desconocido'
                      END as cargo_nombre
                      FROM usuarios ORDER BY cargo ASC, nombre ASC";
            
            $resultado = $conexion->query($query);
            $usuarios = [];
            
            if ($resultado) {
                while ($row = $resultado->fetch_assoc()) {
                    // Si el usuario actual no es root y el usuario a listar es root, ocultar información sensible
                    if ($_SESSION['cargo'] != '0' && $row['cargo'] == '0') {
                        $row['nombre'] = '[Información Restringida]';
                        $row['email'] = '[Email Restringido]';
                    }
                    $usuarios[] = $row;
                }
            }
            
            echo json_encode(['success' => true, 'data' => $usuarios]);
            break;
            
        default:
            echo json_encode(['success' => false, 'message' => 'Acción no válida']);
            break;
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error de conexión: ' . $e->getMessage()]);
}
?>
