# CONFIGURACIÓN DE SERVIDORES ORTHANC - GUÍA COMPLETA

## 📋 RESUMEN DE UBICACIONES

### **🔧 ARCHIVOS PRINCIPALES QUE NECESITAN MODIFICACIÓN:**

---

## **1. `view/user/index.php`** (Usuario común)

### **Línea 21 - Consulta principal de estudios:**
```php
$url = "https://iset.portalpaciente.com.ar/api/find";
```

### **Línea 140 - Consulta de estudios derivados:**
```php
$urlDerivados = "http://localhost:3001/api/find";
```

### **Línea 247 - Consulta de estudios (segunda instancia):**
```php
$url = "https://iset.portalpaciente.com.ar/api/find";
```

### **Línea 826 - URL de descarga de estudios:**
```php
$downloadUrl = "https://iset.portalpaciente.com.ar/isetarc/{$studyInstanceUID}?accept=application/zip&dicomdir=true";
```

### **Línea 836 - URL de visualización con volview:**
```php
$viewUrl = "http://iset.portalpaciente.com.ar:8042/volview/index.html?names=[archive.zip]&urls=[../studies/{$studyID}/archive]";
```

### **Línea 931 - URL de descarga de derivaciones:**
```php
$downloadUrl = "https://iset.portalpaciente.com.ar/api/studies/" . urlencode($derivacion['study_instance_uid']) . "/archive";
```

### **Línea 932 - URL de visualización de derivaciones:**
```php
$viewUrl = "https://iset.portalpaciente.com.ar/viewer/" . urlencode($derivacion['study_instance_uid']);
```

### **Línea 1003 - URL de descarga (segunda instancia):**
```php
$downloadUrl = "https://iset.portalpaciente.com.ar/isetarc/{$studyInstanceUID}?accept=application/zip&dicomdir=true";
```

### **Línea 1006 - URL de visualización (segunda instancia):**
```php
$viewUrl = "http://iset.portalpaciente.com.ar:8042/volview/index.html?names=[archive.zip]&urls=[../studies/{$studyID}/archive]";
```

### **Línea 1893 - URL de descarga en JavaScript:**
```javascript
const downloadUrl = `https://iset.portalpaciente.com.ar/isetarc/${derivacion.study_instance_uid}?accept=application/zip&dicomdir=true`;
```

### **Línea 1896 - URL de visualización en JavaScript:**
```javascript
? `http://iset.portalpaciente.com.ar:8042/volview/index.html?names=[archive.zip]&urls=[../studies/${derivacion.studyID}/archive]`
```

---

## **2. `view/admin/index.php`** (Administrador)

### **Línea 65 - Consulta principal:**
```php
$url = "https://iset.portalpaciente.com.ar/api/find";
```

### **Línea 217 - Consulta secundaria:**
```php
$url = "https://iset.portalpaciente.com.ar/api/find";
```

### **Línea 1068 - URL de descarga:**
```php
$downloadUrl = "https://iset.portalpaciente.com.ar/isetarc/{$studyInstanceUID}?accept=application/zip&dicomdir=true";
```

### **Línea 1071 - URL de visualización:**
```php
$viewUrl = "http://iset.portalpaciente.com.ar:8042/volview/index.html?names=[archive.zip]&urls=[../studies/{$studyID}/archive]";
```

---

## **3. `view/admin/view.php`** (Visualización)

### **Línea 17 - URL base:**
```php
$baseUrl = "http://iset.portalpaciente.com.ar:3000";
```

### **Línea 62 - Configuración de cookies:**
```php
setcookie($name, $value, 0, '/', 'iset.portalpaciente.com.ar');
```

---

## **4. `view/admin/download.php`** (Descarga)

### **Línea 14 - URL base de descarga:**
```php
$baseUrl = "https://iset.portalpaciente.com.ar/isetarc";
```

---

## **5. `controller/derivacionController.php`** (Controlador)

### **Línea 154 - Consulta de estudios:**
```php
$url = "https://iset.portalpaciente.com.ar/api/find";
```

---

## **6. Archivos de respaldo (pueden contener configuraciones antiguas):**

### **`view/admin/index.php.latest`**
- Línea 19: `$url = "http://localhost:3001/api/find";`

### **`view/admin/index.php.curr`**
- Línea 26: `$url = "http://localhost:3001/api/find";`
- Línea 410: URL de visualización

---

## 🔧 **TIPOS DE URLs IDENTIFICADAS:**

### **1. URLs de API (consultas de estudios):**
- `https://iset.portalpaciente.com.ar/api/find`
- `http://localhost:3001/api/find`

### **2. URLs de descarga:**
- `https://iset.portalpaciente.com.ar/isetarc/{studyInstanceUID}?accept=application/zip&dicomdir=true`
- `https://iset.portalpaciente.com.ar/api/studies/{studyInstanceUID}/archive`

### **3. URLs de visualización:**
- `https://iset.portalpaciente.com.ar/viewer/{studyInstanceUID}`
- `http://iset.portalpaciente.com.ar:8042/volview/index.html?names=[archive.zip]&urls=[../studies/{studyID}/archive]`

### **4. URLs base:**
- `http://iset.portalpaciente.com.ar:3000`
- `https://iset.portalpaciente.com.ar/isetarc`

---

## 📝 **INSTRUCCIONES PARA CAMBIAR:**

### **Paso 1: Identificar tu nuevo servidor**
```bash
# Ejemplo: cambiar a servidor local
NUEVO_SERVIDOR="http://localhost:8042"

# Ejemplo: cambiar a servidor de producción
NUEVO_SERVIDOR="https://tu-servidor.com"
```

### **Paso 2: Reemplazar URLs en todos los archivos**
```bash
# Reemplazar en todos los archivos PHP
find . -name "*.php" -exec sed -i 's/https:\/\/iset\.portalpaciente\.com\.ar/NUEVO_SERVIDOR/g' {} \;
find . -name "*.php" -exec sed -i 's/http:\/\/localhost:3001/NUEVO_SERVIDOR/g' {} \;
```

### **Paso 3: Verificar cambios**
```bash
# Buscar referencias restantes
grep -r "iset.portalpaciente.com.ar" .
grep -r "localhost:3001" .
```

---

## ⚠️ **CONSIDERACIONES IMPORTANTES:**

1. **Puertos diferentes:** Algunas URLs usan puerto 3000, 3001, 8042
2. **Protocolos diferentes:** HTTP vs HTTPS
3. **Rutas diferentes:** `/api/find`, `/isetarc`, `/viewer`, `/volview`
4. **Parámetros específicos:** Algunas URLs tienen parámetros específicos
5. **JavaScript:** También hay URLs en código JavaScript que deben cambiarse

---

## 🎯 **RECOMENDACIÓN:**

**Usa el archivo `config/orthanc_config.php`** que creé para centralizar todas las configuraciones y facilitar futuros cambios.
