<?php
session_start();

// Validamos que exista una session y ademas que el cargo que exista sea igual a 1 (Administradores)
if(!isset($_SESSION['cargo']) || $_SESSION['cargo'] != 1){
    header('location: ../../index.php');
}

$refphysician = $_SESSION['nombre'];

// Credenciales
$username = "iset";
$password = "iset";

// Función para validar formato de fecha
function isValidDate($date) {
    $d = DateTime::createFromFormat('Y-m-d', $date);
    return $d && $d->format('Y-m-d') === $date;
}

// Función para validar rango de fechas
function isValidDateRange($startDate, $endDate) {
    $start = new DateTime($startDate);
    $end = new DateTime($endDate);
    $today = new DateTime();
    
    // La fecha de inicio no puede ser posterior a la fecha final
    if ($start > $end) {
        return ['valid' => false, 'message' => 'La fecha de inicio no puede ser posterior a la fecha final'];
    }
    
    // Las fechas no pueden ser futuras
    if ($start > $today || $end > $today) {
        return ['valid' => false, 'message' => 'No se pueden seleccionar fechas futuras'];
    }
    
    // Limitar el rango máximo a 3 meses (90 días)
    $diff = $start->diff($end);
    if ($diff->days > 365) {
        return ['valid' => false, 'message' => 'El rango máximo permitido es de 365 días'];
    }
    
    return ['valid' => true, 'message' => ''];
}

// Inicializar variable para mensajes de error
$errorMessage = '';

// Manejo de fechas con validación
try {
    if (isset($_POST['startDate']) && isset($_POST['endDate'])) {
        // Validar formato de fechas
        if (!isValidDate($_POST['startDate']) || !isValidDate($_POST['endDate'])) {
            throw new Exception('Formato de fecha inválido. Use el formato YYYY-MM-DD');
        }
        
        // Validar rango de fechas
        $dateValidation = isValidDateRange($_POST['startDate'], $_POST['endDate']);
        if (!$dateValidation['valid']) {
            throw new Exception($dateValidation['message']);
        }
        
        // Si pasa todas las validaciones, actualizar sesión
        $_SESSION['startDate'] = $_POST['startDate'];
        $_SESSION['endDate'] = $_POST['endDate'];
        $startDate = str_replace('-', '', $_POST['startDate']);
        $endDate = str_replace('-', '', $_POST['endDate']);
    } elseif (!isset($_SESSION['startDate']) || !isset($_SESSION['endDate'])) {
        // Valores por defecto (7 días)
        $_SESSION['startDate'] = date('Y-m-d', strtotime('-7 days'));
        $_SESSION['endDate'] = date('Y-m-d');
        $startDate = date('Ymd', strtotime('-7 days'));
        $endDate = date('Ymd');
    } else {
        // Usar valores de sesión existentes
        $startDate = str_replace('-', '', $_SESSION['startDate']);
        $endDate = str_replace('-', '', $_SESSION['endDate']);
    }
} catch (Exception $e) {
    // En caso de error, usar últimas fechas válidas de la sesión o valores por defecto
    if (isset($_SESSION['startDate']) && isset($_SESSION['endDate'])) {
        $startDate = str_replace('-', '', $_SESSION['startDate']);
        $endDate = str_replace('-', '', $_SESSION['endDate']);
    } else {
        $_SESSION['startDate'] = date('Y-m-d', strtotime('-7 days'));
        $_SESSION['endDate'] = date('Y-m-d');
        $startDate = date('Ymd', strtotime('-7 days'));
        $endDate = date('Ymd');
    }
    $errorMessage = "Error: " . $e->getMessage();
}

// Datos de la solicitud
$url = "http://localhost:3001/api/find";
$data = json_encode([
    "Level" => "Study",
    "Query" => [
        "StudyDate" => $startDate . "-" . $endDate
    ],
    "Expand" => true
]);

// Inicializar cURL
$ch = curl_init();

// Configurar opciones de cURL
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json"
]);

// Deshabilitar verificación SSL (NO RECOMENDADO PARA PRODUCCIÓN)
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

// Ejecutar la solicitud y obtener la respuesta
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo 'Error en la solicitud: ' . curl_error($ch);
} else {
    // Decodificar la respuesta JSON
    $jsonData = json_decode($response, true);

    if ($jsonData === null) {
        echo "Error al decodificar el JSON";
    } else {
        // Verificar si hay al menos un estudio en los resultados
        if (count($jsonData) > 0) {
            // Obtener el parámetro de ordenamiento
            $sortColumn = isset($_GET['sort']) ? $_GET['sort'] : 'StudyDate';
            $sortOrder = isset($_GET['order']) ? $_GET['order'] : 'desc';

            // Crear un array para ordenamiento
            $sortArray = array();
            foreach ($jsonData as $key => $study) {
                switch ($sortColumn) {
                    case 'PatientName':
                        $sortArray[$key] = $study['PatientMainDicomTags']['PatientName'];
                        break;
                    case 'PatientID':
                        $sortArray[$key] = $study['PatientMainDicomTags']['PatientID'];
                        break;
                    case 'StudyDescription':
                        $sortArray[$key] = $study['MainDicomTags']['StudyDescription'];
                        break;
                    case 'StudyDate':
                        $sortArray[$key] = $study['MainDicomTags']['StudyDate'];
                        break;                    
                    case 'Modality':
                        $sortArray[$key] = $study['MainDicomTags']['Modality'];
                        break;                    
                    case 'ID':
                        $sortArray[$key] = $study['ID'];
                        break;
                    case 'ReferringPhysician':
                        $sortArray[$key] = $study['MainDicomTags']['ReferringPhysicianName'] ?? '';
                        break;
                    default:
                        $sortArray[$key] = $study['MainDicomTags']['StudyDate'];
                }
            }

            // Ordenar el array
            if ($sortOrder === 'asc') {
                asort($sortArray);
            } else {
                arsort($sortArray);
            }

            // Reordenar $jsonData basado en $sortArray
            $sortedData = array();
            foreach ($sortArray as $key => $value) {
                $sortedData[] = $jsonData[$key];
            }
            $jsonData = $sortedData;

            
            if ($errorMessage) {
                echo '<div style="background-color: #ffebee; color: #c62828; padding: 10px; margin: 10px 0; border-radius: 4px; border: 1px solid #ef9a9a;">
                        <strong>¡Atención!</strong> ' . htmlspecialchars($errorMessage) . '
                      </div>';
            }


            // Generar el HTML
            echo '<!DOCTYPE html>
            <html lang="es">
            <head>
                <meta charset="utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1">
                <title>ISET-PROFESIONALES</title>
                <style>
                    body {
                         font-family: Arial, sans-serif;
                         line-height: 1.6;
                         color: #333;
                         max-width: 1200px;
                         margin: 0 auto;
                         padding: 20px;
                         background-color: #f4f4f4;
                     }
                     h1, h3 {
                         color: #2c3e50;
                     }
                     .welcome-message {
                         background-color: #3498db;
                         color: white;
                         padding: 10px;
                         border-radius: 5px;
                         margin-bottom: 20px;
                     }
                     .logout-button {
                         background-color: #e74c3c;
                         color: white;
                         border: none;
                         padding: 10px 15px;
                         border-radius: 5px;
                         cursor: pointer;
                         transition: background-color 0.3s;
                     }
                     .logout-button:hover {
                         background-color: #c0392b;
                     }
                     table {
                         width: 100%;
                         border-collapse: separate;
                         border-spacing: 0;
                         background-color: white;
                         border-radius: 10px;
                         overflow: hidden;
                         box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
                     }
                     th, td {
                         padding: 15px;
                         text-align: left;
                         border-bottom: 1px solid #ecf0f1;
                     }
                     th {
                         background-color: #4CAF50;
                         color: white;
                         font-weight: bold;
                         text-transform: uppercase;
                         letter-spacing: 0.03em;
                         cursor: pointer;
                     }
                     th:hover {
                         background-color: #45a049;
                     }
                     tr:nth-child(even) {
                         background-color: #f9f9f9;
                     }
                     tr:hover {
                         background-color: #f5f5f5;
                     }
                     .actions {
                         display: flex;
                         justify-content: space-around;
                     }
                     .action-button {
                         padding: 8px 12px;
                         border-radius: 5px;
                         text-decoration: none;
                         color: white;
                         font-weight: bold;
                         transition: background-color 0.3s;
                     }
                     .download {
                         background-color: #3498db;
                     }
                     .download:hover {
                         background-color: #2980b9;
                     }
                     .download.error {
                         background-color: #e74c3c;
                     }
                     .download.success {
                         background-color: #2ecc71;
                     }
                     .view {
                         background-color: #3498db;
                     }
                     .view:hover {
                         background-color: #2980b9;
                     }
                     .spinner {
                         display: inline-block;
                         width: 20px;
                         height: 20px;
                         border: 3px solid rgba(255,255,255,.3);
                         border-radius: 50%;
                         border-top-color: #fff;
                         animation: spin 1s ease-in-out infinite;
                         margin-right: 10px;
                     }
                     @keyframes spin {
                         to { transform: rotate(360deg); }
                     }
                     .download:disabled {
                         background-color: #95a5a6;
                         cursor: not-allowed;
                     }
                     #searchInput {
                         width: 100%;
                         padding: 12px 20px;
                         margin: 8px 0;
                         display: inline-block;
                         border: 1px solid #ccc;
                         border-radius: 4px;
                         box-sizing: border-box;
                     }
                     .logo-container {
                         text-align: center;
                         margin-bottom: 20px;
                     }
                     .logo {
                         max-width: 200px;
                         height: auto;
                     }
                    .date-filter {
                        background-color: white;
                        padding: 20px;
                        border-radius: 10px;
                        margin: 20px 0;
                        box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
                    }
                    .date-filter form {
                        display: flex;
                        gap: 20px;
                        align-items: center;
                    }
                    .date-filter input[type="date"] {
                        padding: 8px;
                        border: 1px solid #ddd;
                        border-radius: 4px;
                    }
                    .filter-button {
                        background-color: #4CAF50;
                        color: white;
                        border: none;
                        padding: 10px 20px;
                        border-radius: 5px;
                        cursor: pointer;
                        transition: background-color 0.3s;
                    }
                    .filter-button:hover {
                        background-color: #45a049;
                    }
                    .header-buttons {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        margin-bottom: 20px;
                    }
                    .download-app-button {
                        background-color: #27ae60;
                        color: white;
                        border: none;
                        padding: 10px 15px;
                        border-radius: 5px;
                        cursor: pointer;
                        text-decoration: none;
                        display: inline-block;
                        transition: background-color 0.3s;
                    }
                    .download-app-button:hover {
                        background-color: #229954;
                        color: white;
                        text-decoration: none;
                    }
                </style>
                 <script>
                 function downloadAndRename(url, patientName, buttonElement) {
                     buttonElement.disabled = true;
                     buttonElement.innerHTML = "<span class=\'spinner\'></span>Descargando...";
                     buttonElement.classList.remove("error", "success");
 
                     fetch(url)
                         .then(response => {
                             if (!response.ok) {
                                 throw new Error("HTTP error " + response.status);
                             }
                             return response.blob();
                         })
                         .then(blob => {
                             const url = window.URL.createObjectURL(blob);
                             const a = document.createElement("a");
                             a.style.display = "none";
                             a.href = url;
                             a.download = patientName + ".zip";
                             document.body.appendChild(a);
                             a.click();
                             window.URL.revokeObjectURL(url);
                             
                             buttonElement.classList.add("success");
                             buttonElement.innerHTML = "Descarga exitosa";
                             setTimeout(() => {
                                 buttonElement.classList.remove("success");
                                 buttonElement.innerHTML = "Descargar";
                             }, 3000);
                         })
                         .catch(error => {
                             console.error("Error en la descarga:", error);
                             alert("Hubo un error en la descarga. Por favor, inténtelo de nuevo.");
                             
                             buttonElement.classList.add("error");
                             buttonElement.innerHTML = "Error en descarga";
                             setTimeout(() => {
                                 buttonElement.classList.remove("error");
                                 buttonElement.innerHTML = "Descargar";
                             }, 3000);
                         })
                         .finally(() => {
                             buttonElement.disabled = false;
                         });
                 }
 
                 function searchTable() {
                    var input, filter, table, tr, td, i, txtValue;
                    input = document.getElementById("searchInput");
                    filter = input.value.toUpperCase();
                    table = document.querySelector("table");
                    tr = table.getElementsByTagName("tr");
                    var visibleCount = 0;
                    for (i = 0; i < tr.length; i++) {
                        td = tr[i].getElementsByTagName("td");
                        if (td.length > 0) { // Asegurarse de que no es una fila de encabezado
                            var rowVisible = false;
                            for (var j = 0; j < td.length; j++) {
                                if (td[j]) {
                                    txtValue = td[j].textContent || td[j].innerText;
                                    if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                        rowVisible = true;
                                        break;
                                    }
                                }
                            }
                            if (rowVisible) {
                                tr[i].style.display = "";
                                visibleCount++;
                            } else {
                                tr[i].style.display = "none";
                            }
                        }
                    }
                    // Actualizar el contador de estudios
                    document.getElementById("studyCount").textContent = visibleCount;
                }
                 </script>
             </head>
            <body>
                <div class="logo-container">
                    <img src="isettacselogotransparent.png" alt="Logo ISET" class="logo">
                </div>

                <div class="welcome-message">
                    <h1>Hola estimado colega ' . strtoupper($_SESSION['nombre']) . '</h1>
                    <p>Estos son los estudios de tus pacientes, solicitados a ISET:</p>
                </div>
                
                <div class="date-filter">
                    <form method="post">
                        <label>
                            Fecha inicio:
                            <input type="date" 
                                name="startDate" 
                                value="' . htmlspecialchars($_SESSION['startDate']) . '" 
                                max="' . date('Y-m-d') . '"
                                required>
                        </label>
                        <label>
                            Fecha fin:
                            <input type="date" 
                                name="endDate" 
                                value="' . htmlspecialchars($_SESSION['endDate']) . '" 
                                max="' . date('Y-m-d') . '"
                                required>
                        </label>
                        <button type="submit" class="filter-button">Filtrar</button>
                    </form>
                </div>

                <div class="header-buttons">
                    <a href="../../controller/cerrarSesion.php">
                        <button class="logout-button" type="button">Cerrar sesión</button>
                    </a>
                    <a href="../../controller/downloadApp.php" class="download-app-button">
                        Descargar OnDemand 3D Communicator
                    </a>
                </div>

                <h3>Estudios: <span id="studyCount">' . count($jsonData) . '</span> encontrados</h3>
                <input type="text" id="searchInput" onkeyup="searchTable()" placeholder="Buscar en la lista...">
                <table>
                    <thead>
                        <tr>
                            <th><a href="?sort=PatientName&order=' . ($sortColumn == 'PatientName' && $sortOrder == 'asc' ? 'desc' : 'asc') . '">NOMBRE</a></th>
                            <th><a href="?sort=PatientID&order=' . ($sortColumn == 'PatientID' && $sortOrder == 'asc' ? 'desc' : 'asc') . '">ID</a></th>
                            <th><a href="?sort=StudyDescription&order=' . ($sortColumn == 'StudyDescription' && $sortOrder == 'asc' ? 'desc' : 'asc') . '">DESCRIPCIÓN</a></th>                            
                            <th><a href="?sort=StudyDate&order=' . ($sortColumn == 'StudyDate' && $sortOrder == 'asc' ? 'desc' : 'asc') . '">FECHA</a></th>
                            <th><a href="?sort=ReferringPhysician&order=' . ($sortColumn == 'ReferringPhysician' && $sortOrder == 'asc' ? 'desc' : 'asc') . '">PROFESIONAL</a></th>
                            <th>ACCIONES</th>
                        </tr>
                    </thead>
                    <tbody>';

            foreach ($jsonData as $study) {
                $patientName = str_replace("^", " ", $study['PatientMainDicomTags']['PatientName'] ?? '');
                $patientid = str_replace("^", " ", $study['PatientMainDicomTags']['PatientID'] ?? '');
                $studydescription = str_replace("^", " ", $study['MainDicomTags']['StudyDescription'] ?? '');
                $referringPhysician = str_replace("^", " ", $study['MainDicomTags']['ReferringPhysicianName'] ?? 'No especificado');
                $safePatientName = preg_replace('/[^a-zA-Z0-9_-]/', '_', $patientName);
                $studyInstanceUID = $study['MainDicomTags']['StudyInstanceUID'];                
                $studyID = $study['ID'];
                $downloadUrl = "https://iset.portalpaciente.com.ar/isetarc/{$studyInstanceUID}?accept=application/zip&dicomdir=true";
                
                if (stripos($studydescription, 'Cone') !== false) {
                    $viewUrl = "http://iset.portalpaciente.com.ar:8042/volview/index.html?names=[archive.zip]&urls=[../studies/{$studyID}/archive]";
                } else {
                    $viewUrl = "view.php?study=" . $study['MainDicomTags']['StudyInstanceUID'];
                }

                echo "<tr>
                        <td>" . htmlspecialchars($patientName) . "</td>
                        <td>" . htmlspecialchars($patientid) . "</td>
                        <td>" . htmlspecialchars($studydescription ?: 'No disponible') . "</td>
                        <td>" . date("d/m/Y", strtotime($study['MainDicomTags']['StudyDate'])) . "</td>
                        <td>" . htmlspecialchars($referringPhysician) . "</td>
                        <td class='actions'>
                            <button onclick='downloadAndRename(\"" . htmlspecialchars($downloadUrl) . "\", \"" . htmlspecialchars($safePatientName) . "\", this)' class='action-button download'>Descargar</button>
                            <a href='" . htmlspecialchars($viewUrl) . "' target='_blank' rel='noopener noreferrer' class='action-button view'>Visualizar</a>
                        </td>
                      </tr>";
            }

            echo '</tbody>
                </table>
            </body>
            </html>';
        } else {
            echo "No se encontraron estudios para el rango de fechas seleccionado.";
        }
    }
}
// Cerrar cURL
curl_close($ch);
?>
