<?php

  /*
    En ocasiones el usuario puede volver al login
    aun si ya existe una sesion iniciada, lo correcto
    es no mostrar otra ves el login sino redireccionarlo
    a su pagina principal mientras exista una sesion entonces
    creamos un archivo que controle el redireccionamiento
  */

  session_start();

  // isset verifica si existe una variable o eso creo xd
  if(isset($_SESSION['id'])){
    header('location: controller/redirec.php');
  }

?>


<!DOCTYPE html>
<html lang="es">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso a ISET - Sistema de Gestión</title>

    <!-- Importamos los estilos de Bootstrap -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <!-- Font Awesome: para los iconos -->
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <!-- Sweet Alert: alertas JavaScript presentables para el usuario (más bonitas que el alert) -->
    <link rel="stylesheet" href="css/sweetalert.css">
    <!-- Estilos personalizados: archivo personalizado 100% real no feik -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary-color: #2563eb;
        --primary-dark: #1d4ed8;
        --secondary-color: #64748b;
        --accent-color: #f1f5f9;
        --text-primary: #1e293b;
        --text-secondary: #64748b;
        --border-color: #e2e8f0;
        --success-color: #10b981;
        --error-color: #ef4444;
        --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
        --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
        --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
      }

      * {
        box-sizing: border-box;
      }

      body {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        margin: 0;
        padding: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--text-primary);
        line-height: 1.6;
      }

      .login-container {
        width: 100%;
        max-width: 420px;
        margin: 0 auto;
        padding: 20px;
      }

      .login-card {
        background: white;
        border-radius: 16px;
        box-shadow: var(--shadow-lg);
        overflow: hidden;
        position: relative;
      }

      .login-header {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
        color: white;
        padding: 40px 32px 32px;
        text-align: center;
        position: relative;
      }

      .login-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.3;
      }

      .logo-container {
        position: relative;
        z-index: 1;
        margin-bottom: 16px;
      }

      .logo {
        width: 80px;
        height: 80px;
        background: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 16px;
        box-shadow: var(--shadow-md);
      }

      .logo img {
        width: 60px;
        height: 60px;
        object-fit: contain;
      }

      .login-title {
        font-size: 28px;
        font-weight: 700;
        margin: 0 0 8px;
        position: relative;
        z-index: 1;
      }

      .login-subtitle {
        font-size: 16px;
        font-weight: 400;
        opacity: 0.9;
        margin: 0;
        position: relative;
        z-index: 1;
      }

      .login-body {
        padding: 32px;
      }

      .form-group {
        margin-bottom: 24px;
      }

      .form-label {
        display: block;
        font-size: 14px;
        font-weight: 500;
        color: var(--text-primary);
        margin-bottom: 8px;
      }

      .input-group {
        position: relative;
        display: flex;
        align-items: center;
        background: #f8fafc;
        border: 2px solid transparent;
        border-radius: 12px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        overflow: hidden;
      }

      .input-group:hover {
        background: #f1f5f9;
      }

      .input-group:focus-within {
        background: white;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
      }

      .input-group.focused {
        background: white;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
      }

      .input-group.has-value {
        background: white;
        border-color: var(--border-color);
      }

      .input-group.has-value:focus-within {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
      }

      .input-group-addon {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 48px;
        height: 48px;
        background: transparent;
        border: none;
        color: var(--text-secondary);
        font-size: 18px;
      }

      .input-group-addon i {
        transition: color 0.3s ease;
      }

      .input-group:focus-within .input-group-addon i {
        color: var(--primary-color);
      }

      .form-control {
        flex: 1;
        border: none;
        background: transparent;
        padding: 16px 16px 16px 0;
        font-size: 16px;
        font-weight: 400;
        color: var(--text-primary);
        outline: none;
      }

      .form-control::placeholder {
        color: var(--text-secondary);
        opacity: 0.7;
      }

      .btn-login {
        width: 100%;
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
        border: none;
        border-radius: 12px;
        padding: 16px 24px;
        font-size: 16px;
        font-weight: 600;
        color: white;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: var(--shadow-md);
        position: relative;
        overflow: hidden;
      }

      .btn-login:hover {
        transform: translateY(-2px);
        box-shadow: var(--shadow-lg);
        background: linear-gradient(135deg, var(--primary-dark) 0%, #1e40af 100%);
      }

      .btn-login:active {
        transform: translateY(0);
      }

      .btn-login:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        transform: none;
      }

      .btn-login::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s;
      }

      .btn-login:hover::before {
        left: 100%;
      }

      .register-link {
        text-align: center;
        margin-top: 24px;
        padding-top: 24px;
        border-top: 1px solid var(--border-color);
      }

      .register-link p {
        margin: 0;
        color: var(--text-secondary);
        font-size: 14px;
      }

      .register-link a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 500;
        transition: color 0.3s ease;
      }

      .register-link a:hover {
        color: var(--primary-dark);
        text-decoration: underline;
      }

      .loading-container {
        display: none;
        text-align: center;
        padding: 20px;
      }

      .loading-container.show {
        display: block;
      }

      .spinner {
        width: 40px;
        height: 40px;
        border: 4px solid #f3f3f3;
        border-top: 4px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 16px;
      }

      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }

      .loading-text {
        color: var(--text-secondary);
        font-size: 14px;
        font-weight: 500;
      }

      /* Responsive Design */
      @media (max-width: 480px) {
        .login-container {
          padding: 16px;
        }

        .login-header {
          padding: 32px 24px 24px;
        }

        .login-body {
          padding: 24px;
        }

        .login-title {
          font-size: 24px;
        }

        .logo {
          width: 64px;
          height: 64px;
        }

        .logo img {
          width: 48px;
          height: 48px;
        }
      }

      /* Animation for card entrance */
      .login-card {
        animation: slideUp 0.6s ease-out;
      }

      @keyframes slideUp {
        from {
          opacity: 0;
          transform: translateY(30px);
        }
        to {
          opacity: 1;
          transform: translateY(0);
        }
      }

      /* Focus styles for accessibility */
      .form-control:focus {
        outline: none;
      }

      .btn-login:focus {
        outline: none;
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.3);
      }

      /* Loading animation improvements */
      .spinner {
        width: 40px;
        height: 40px;
        border: 4px solid #f3f3f3;
        border-top: 4px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 16px;
      }

      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }
    </style>
  </head>
  <body>
    <div class="login-container">
      <div class="login-card">
        <!-- Header Section -->
        <div class="login-header">
          <div class="logo-container">
            <div class="logo">
              <img src="view/admin/isettacselogotransparent.png" alt="ISET Logo" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
              <div class="logo-fallback" style="display: none; width: 60px; height: 60px; background: var(--primary-color); border-radius: 50%; align-items: center; justify-content: center; color: white; font-size: 24px; font-weight: bold;">
                ISET
              </div>
            </div>
            <h1 class="login-title">Bienvenido</h1>
            <p class="login-subtitle">Accede a tu cuenta de ISET</p>
          </div>
        </div>

        <!-- Body Section -->
        <div class="login-body">
          <form id="loginForm">
            <!-- Usuario -->
            <div class="form-group">
              <label class="form-label" for="user">Usuario</label>
              <div class="input-group">
                <div class="input-group-addon">
                  <i class="fa fa-user"></i>
                </div>
                <input type="text" class="form-control" id="user" name="user" placeholder="Ingresa tu usuario" required>
              </div>
            </div>

            <!-- Contraseña -->
            <div class="form-group">
              <label class="form-label" for="clave">Contraseña</label>
              <div class="input-group">
                <div class="input-group-addon">
                  <i class="fa fa-lock"></i>
                </div>
                <input type="password" class="form-control" id="clave" name="clave" placeholder="Ingresa tu contraseña" autocomplete="off" required>
              </div>
            </div>

            <!-- Loading Animation -->
            <div class="loading-container" id="load">
              <div class="spinner"></div>
              <div class="loading-text">Validando información...</div>
            </div>

            <!-- Login Button -->
            <button type="button" class="btn-login" id="login">
              <span class="btn-text">Iniciar Sesión</span>
            </button>

            <!-- Register Link -->
            <div class="register-link">
              <p>
                ¿No tienes una cuenta? <a href="registro.php">Regístrate aquí</a>
              </p>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Jquery -->
    <script src="js/jquery.js"></script>
    <!-- Bootstrap js -->
    <script src="js/bootstrap.min.js"></script>
    <!-- SweetAlert js -->
    <script src="js/sweetalert.min.js"></script>
    <!-- Js personalizado -->
    <script src="js/operaciones.js"></script>

    <script>
      // Enhanced login functionality that works with existing operaciones.js
      $(document).ready(function() {
        const loginBtn = $('#login');
        const loadContainer = $('#load');
        const btnText = $('.btn-text');

        // Override the existing login functionality to work with our new design
        $('#login').off('click').on('click', function(){
          // Traemos los datos de los inputs
          var user = $('#user').val().trim();
          var clave = $('#clave').val().trim();

          // Validation
          if (!user || !clave) {
            swal('Error', 'Por favor ingrese todos los campos', 'error');
            return;
          }

          // Show loading state with our new design
          loginBtn.prop('disabled', true);
          btnText.text('Iniciando sesión...');
          loadContainer.addClass('show');

          // Envio de datos mediante Ajax
          $.ajax({
            method: 'POST',
            url: 'controller/loginController.php',
            data: {user_php: user, clave_php: clave},
            beforeSend: function(){
              // Loading state is already handled above
            },
            success: function(res){
              // Hide loading state
              loginBtn.prop('disabled', false);
              btnText.text('Iniciar Sesión');
              loadContainer.removeClass('show');

              // Validate the response
              if(res == 'error_1'){
                swal('Error', 'Por favor ingrese todos los campos', 'error');
              }else if(res == 'error_2'){
                swal('Error', 'Por favor ingrese un email valido', 'warning');
              }else if(res == 'error_3'){
                swal('Error', 'El usuario y contraseña que ingresaste es incorrecto', 'error');
              }else{
                // Redireccionamos a la página que diga corresponda el usuario
                window.location.href = res;
              }
            },
            error: function() {
              // Handle AJAX errors
              loginBtn.prop('disabled', false);
              btnText.text('Iniciar Sesión');
              loadContainer.removeClass('show');
              swal('Error', 'Error de conexión. Por favor intente nuevamente.', 'error');
            }
          });
        });

        // Handle form submission
        $('#loginForm').on('submit', function(e) {
          e.preventDefault();
          $('#login').click();
        });

        // Handle Enter key press
        $('#user, #clave').on('keypress', function(e) {
          if (e.which === 13) {
            $('#login').click();
          }
        });

        // Add focus effects for better UX
        $('.input-group').on('focusin', function() {
          $(this).addClass('focused');
        }).on('focusout', function() {
          $(this).removeClass('focused');
        });

        // Add input validation feedback
        $('.form-control').on('input', function() {
          const $input = $(this);
          const $inputGroup = $input.closest('.input-group');
          
          if ($input.val().trim()) {
            $inputGroup.addClass('has-value');
          } else {
            $inputGroup.removeClass('has-value');
          }
        });
      });
    </script>
  </body>
</html>
