# Migración: Funcionalidad de Ocultar Derivaciones Recibidas

## Descripción
Esta migración agrega la funcionalidad para que los usuarios puedan marcar derivaciones recibidas como "vistas" y ocultarlas permanentemente de su lista y avisos.

## Archivos Modificados

### 1. Base de Datos
- **Archivo**: `db/migration_ocultar_derivaciones.sql`
- **Cambio**: Agregar campo `oculta_por_usuario JSON` a la tabla `derivaciones`

### 2. Controlador
- **Archivo**: `controller/derivacionController.php`
- **Cambios**:
  - Modificar caso 'desactivar' para permitir cancelar derivaciones por origen o destino
  - Agregar nuevo caso 'ocultar_derivacion' para marcar derivaciones como ocultas
  - Modificar consultas para filtrar derivaciones ocultas

### 3. Vista de Usuarios
- **Archivo**: `view/user/index.php`
- **Cambios**:
  - Agregar botón "✅ Marcar como vista" en derivaciones recibidas
  - Agregar funciones JavaScript `ocultarDerivacionRecibida()` y `procesarOcultacion()`
  - Modificar consultas para excluir derivaciones ocultas

## Instrucciones de Instalación

### Paso 1: Ejecutar Migración de Base de Datos
```sql
-- Ejecutar en MySQL/MariaDB
ALTER TABLE derivaciones ADD COLUMN oculta_por_usuario JSON DEFAULT NULL COMMENT 'Array JSON de IDs de usuarios que han ocultado esta derivación';
```

### Paso 2: Verificar Archivos
Los archivos ya han sido modificados con los cambios necesarios:
- ✅ `controller/derivacionController.php`
- ✅ `view/user/index.php`
- ✅ `db/migration_ocultar_derivaciones.sql`

## Funcionalidad Implementada

### Para Derivaciones Enviadas:
- **Botón**: "❌ Cancelar"
- **Acción**: Cancela la derivación (la desactiva)
- **Permisos**: Solo el usuario origen puede cancelar

### Para Derivaciones Recibidas:
- **Botón**: "✅ Marcar como vista"
- **Acción**: Oculta permanentemente la derivación de la lista del usuario
- **Permisos**: Solo el usuario destino puede ocultar
- **Persistencia**: La derivación no vuelve a aparecer en avisos ni lista

## Beneficios

1. **Persistente**: Las derivaciones ocultas no vuelven a aparecer
2. **Limpia avisos**: No aparecen en notificaciones de derivaciones pendientes
3. **UX mejorada**: Los usuarios pueden mantener su panel limpio
4. **Seguro**: Solo el usuario destino puede ocultar sus derivaciones recibidas
5. **Flexible**: Permite que diferentes usuarios oculten la misma derivación independientemente

## Pruebas Recomendadas

1. **Crear una derivación** desde una cuenta de administrador hacia un usuario
2. **Verificar que aparece** en la lista de derivaciones recibidas del usuario
3. **Hacer clic en "✅ Marcar como vista"** y confirmar
4. **Verificar que la derivación desaparece** de la lista
5. **Refrescar la página** y verificar que no vuelve a aparecer
6. **Verificar que no aparece** en avisos de derivaciones pendientes

## Notas Técnicas

- Utiliza campos JSON para almacenar múltiples usuarios que pueden ocultar la misma derivación
- Las consultas SQL utilizan `JSON_SEARCH()` para filtrar derivaciones ocultas
- Compatible con MySQL 5.7+ y MariaDB 10.2+
- Mantiene compatibilidad con funcionalidad existente

