<?php
session_start();
require_once('../model/conexion.php');

// Verificar que el usuario esté logueado (Root, Admin o Usuario)
if(!isset($_SESSION['cargo']) || ($_SESSION['cargo'] != '0' && $_SESSION['cargo'] != '1' && $_SESSION['cargo'] != '2')){
    header('location: ../index.php');
    exit();
}

$conexion = new Conexion();
$conexion->conectar();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    // Log para debugging
    error_log("DerivacionController - Action: " . $action);
    error_log("DerivacionController - POST data: " . print_r($_POST, true));
    
    switch ($action) {
        case 'derivar':
            $studyUID = $conexion->salvar($_POST['study_uid'] ?? '');
            $usuarioDestino = (int)($_POST['usuario_destino'] ?? '');
            $comentario = $conexion->salvar($_POST['comentario'] ?? '');
            $usuarioOrigen = (int)$_SESSION['id'];
            
            error_log("DerivacionController - Derivando estudio: studyUID=$studyUID, usuarioDestino=$usuarioDestino, usuarioOrigen=$usuarioOrigen");
            
            if (!empty($studyUID) && !empty($usuarioDestino)) {
                // Verificar que no exista ya una derivación activa (solo activas, no canceladas)
                $consultaExiste = "SELECT id FROM derivaciones WHERE study_instance_uid = '$studyUID' AND usuario_origen_id = $usuarioOrigen AND usuario_destino_id = $usuarioDestino AND activo = 1";
                
                if ($conexion->verificarRegistros($consultaExiste) == 0) {
                    // Si existe una derivación cancelada, reactivarla con el nuevo comentario
                    $consultaCancelada = "SELECT id FROM derivaciones WHERE study_instance_uid = '$studyUID' AND usuario_origen_id = $usuarioOrigen AND usuario_destino_id = $usuarioDestino AND activo = 0";
                    $resultadoCancelada = $conexion->query($consultaCancelada);
                    
                    if ($resultadoCancelada && $resultadoCancelada->num_rows > 0) {
                        // Reactivar la derivación existente
                        $row = $resultadoCancelada->fetch_assoc();
                        $consulta = "UPDATE derivaciones SET activo = 1, comentario = '$comentario', fecha_derivacion = NOW() WHERE id = " . (int)$row['id'];
                        error_log("DerivacionController - Reactivando derivación existente: " . $row['id']);
                    } else {
                        // Crear nueva derivación
                        $consulta = "INSERT INTO derivaciones (study_instance_uid, usuario_origen_id, usuario_destino_id, comentario) VALUES ('$studyUID', $usuarioOrigen, $usuarioDestino, '$comentario')";
                        error_log("DerivacionController - Creando nueva derivación");
                    }
                    
                    if ($conexion->query($consulta)) {
                        error_log("DerivacionController - Derivación exitosa");
                        echo json_encode(['success' => true, 'message' => 'Estudio derivado exitosamente']);
                    } else {
                        error_log("DerivacionController - Error en query: " . $conexion->error);
                        echo json_encode(['success' => false, 'message' => 'Error al derivar el estudio']);
                    }
                } else {
                    error_log("DerivacionController - Ya existe derivación activa");
                    echo json_encode(['success' => false, 'message' => 'Ya existe una derivación activa para este estudio y usuario']);
                }
            } else {
                error_log("DerivacionController - Datos incompletos: studyUID=$studyUID, usuarioDestino=$usuarioDestino");
                echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
            }
            break;
            
        case 'desactivar':
            $derivacionId = $_POST['derivacion_id'] ?? '';
            $usuarioActual = $_SESSION['id'];
            
            if (!empty($derivacionId)) {
                // Permitir cancelar si es el usuario origen O el usuario destino
                $consulta = "UPDATE derivaciones SET activo = 0 WHERE id = $derivacionId AND (usuario_origen_id = $usuarioActual OR usuario_destino_id = $usuarioActual)";
                
                if ($conexion->query($consulta)) {
                    echo json_encode(['success' => true, 'message' => 'Derivación cancelada exitosamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al cancelar la derivación']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'ID de derivación no válido']);
            }
            break;
            
        case 'ocultar_derivacion':
            $derivacionId = $_POST['derivacion_id'] ?? '';
            $usuarioActual = $_SESSION['id'];
            
            error_log("OcultarDerivacion - DerivacionID: $derivacionId, UsuarioActual: $usuarioActual");
            
            if (!empty($derivacionId)) {
                // Solo el usuario destino puede ocultar derivaciones recibidas
                $consulta = "UPDATE derivaciones SET oculta_por_usuario = JSON_ARRAY_APPEND(COALESCE(oculta_por_usuario, '[]'), '$', $usuarioActual) WHERE id = $derivacionId AND usuario_destino_id = $usuarioActual";
                
                error_log("OcultarDerivacion - Consulta: $consulta");
                
                if ($conexion->query($consulta)) {
                    error_log("OcultarDerivacion - Éxito: Derivación oculta");
                    echo json_encode(['success' => true, 'message' => 'Derivación oculta exitosamente']);
                } else {
                    error_log("OcultarDerivacion - Error: " . $conexion->error);
                    echo json_encode(['success' => false, 'message' => 'Error al ocultar la derivación: ' . $conexion->error]);
                }
            } else {
                error_log("OcultarDerivacion - Error: ID de derivación no válido");
                echo json_encode(['success' => false, 'message' => 'ID de derivación no válido']);
            }
            break;
            
        case 'mostrar_derivacion':
            $derivacionId = $_POST['derivacion_id'] ?? '';
            $usuarioActual = $_SESSION['id'];
            
            error_log("MostrarDerivacion - DerivacionID: $derivacionId, UsuarioActual: $usuarioActual");
            
            if (!empty($derivacionId)) {
                // Solo el usuario destino puede mostrar derivaciones ocultas
                $consulta = "UPDATE derivaciones SET oculta_por_usuario = JSON_REMOVE(oculta_por_usuario, JSON_UNQUOTE(JSON_SEARCH(oculta_por_usuario, 'one', $usuarioActual))) WHERE id = $derivacionId AND usuario_destino_id = $usuarioActual";
                
                error_log("MostrarDerivacion - Consulta: $consulta");
                
                if ($conexion->query($consulta)) {
                    error_log("MostrarDerivacion - Éxito: Derivación mostrada");
                    echo json_encode(['success' => true, 'message' => 'Derivación mostrada exitosamente']);
                } else {
                    error_log("MostrarDerivacion - Error: " . $conexion->error);
                    echo json_encode(['success' => false, 'message' => 'Error al mostrar la derivación: ' . $conexion->error]);
                }
            } else {
                error_log("MostrarDerivacion - Error: ID de derivación no válido");
                echo json_encode(['success' => false, 'message' => 'ID de derivación no válido']);
            }
            break;
            
        case 'obtener_usuarios':
            $usuarioActual = $_SESSION['id'];
            $consulta = "SELECT id, nombre, email FROM usuarios WHERE id != $usuarioActual AND cargo IN (1, 2) ORDER BY nombre";
            $resultado = $conexion->query($consulta);
            
            $usuarios = [];
            while ($row = $resultado->fetch_assoc()) {
                $usuarios[] = $row;
            }
            
            echo json_encode(['success' => true, 'usuarios' => $usuarios]);
            break;
            
        case 'obtener_derivaciones':
            $usuarioId = $_SESSION['id'];
            $nuevasDerivaciones = [];
            
            // Función para obtener información del estudio
            function obtenerInfoEstudioController($studyInstanceUID) {
                $url = "https://iset.portalpaciente.com.ar/api/find";
                $data = json_encode([
                    "Level" => "Study",
                    "Query" => [
                        "StudyInstanceUID" => $studyInstanceUID
                    ],
                    "Expand" => true
                ]);
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                
                $response = curl_exec($ch);
                curl_close($ch);
                
                $jsonData = json_decode($response, true);
                
                if ($jsonData && count($jsonData) > 0) {
                    $study = $jsonData[0];
                    return [
                        'patientName' => str_replace("^", " ", $study['PatientMainDicomTags']['PatientName'] ?? ''),
                        'studyDate' => $study['MainDicomTags']['StudyDate'] ?? '',
                        'studyDescription' => str_replace("^", " ", $study['MainDicomTags']['StudyDescription'] ?? ''),
                        'studyID' => $study['ID'] ?? ''
                    ];
                }
                
                return null;
            }
            
            // Obtener derivaciones enviadas
            $consultaEnviadas = "SELECT d.*, u.nombre as usuario_destino_nombre, u.email as usuario_destino_email 
                                FROM derivaciones d 
                                JOIN usuarios u ON d.usuario_destino_id = u.id 
                                WHERE d.usuario_origen_id = $usuarioId AND d.activo = 1 
                                ORDER BY d.fecha_derivacion DESC";
            $resultadoEnviadas = $conexion->query($consultaEnviadas);
            
            $derivacionesEnviadas = [];
            while ($row = $resultadoEnviadas->fetch_assoc()) {
                $infoEstudio = obtenerInfoEstudioController($row['study_instance_uid']);
                $row['patientName'] = $infoEstudio['patientName'] ?? 'No disponible';
                $row['studyDate'] = $infoEstudio['studyDate'] ?? 'No disponible';
                $row['studyDescription'] = $infoEstudio['studyDescription'] ?? 'No disponible';
                $derivacionesEnviadas[] = $row;
            }
            
            // Obtener derivaciones recibidas (excluyendo las ocultas por el usuario)
            $consultaRecibidas = "SELECT d.*, u.nombre as usuario_origen_nombre, u.email as usuario_origen_email 
                                 FROM derivaciones d 
                                 JOIN usuarios u ON d.usuario_origen_id = u.id 
                                 WHERE d.usuario_destino_id = $usuarioId AND d.activo = 1 
                                 AND (d.oculta_por_usuario IS NULL OR JSON_CONTAINS(d.oculta_por_usuario, CAST($usuarioId AS JSON)) = 0)
                                 ORDER BY d.fecha_derivacion DESC";
            $resultadoRecibidas = $conexion->query($consultaRecibidas);
            
            $derivacionesRecibidas = [];
            while ($row = $resultadoRecibidas->fetch_assoc()) {
                $infoEstudio = obtenerInfoEstudioController($row['study_instance_uid']);
                $row['patientName'] = $infoEstudio['patientName'] ?? 'No disponible';
                $row['studyDate'] = $infoEstudio['studyDate'] ?? 'No disponible';
                $row['studyDescription'] = $infoEstudio['studyDescription'] ?? 'No disponible';
                $row['studyID'] = $infoEstudio['studyID'] ?? '';
                // Asegurar que los campos de estado estén presentes
                $row['vista'] = $row['vista'] ?? 0;
                $row['descargada'] = $row['descargada'] ?? 0;
                $derivacionesRecibidas[] = $row;
            }
            
            // Verificar si hay nuevas derivaciones (comparar con la última actualización)
            $ultimaActualizacion = $_POST['ultima_actualizacion'] ?? '';
            $nuevasDerivaciones = []; // Inicializar el array
            
            error_log("DerivacionController - Última actualización recibida: " . $ultimaActualizacion);
            
            if (!empty($ultimaActualizacion)) {
                $timestamp = strtotime($ultimaActualizacion);
                error_log("DerivacionController - Timestamp convertido: " . $timestamp);
                
                foreach ($derivacionesRecibidas as $derivacion) {
                    $derivacionTimestamp = strtotime($derivacion['fecha_derivacion']);
                    error_log("DerivacionController - Comparando: derivación " . $derivacionTimestamp . " vs última " . $timestamp);
                    
                    if ($derivacionTimestamp > $timestamp) {
                        error_log("DerivacionController - Nueva derivación encontrada: " . $derivacion['patientName']);
                        $nuevasDerivaciones[] = [
                            'patientName' => $derivacion['patientName'],
                            'usuario_origen_nombre' => $derivacion['usuario_origen_nombre'],
                            'studyDescription' => $derivacion['studyDescription'] ?? 'No especificado'
                        ];
                    }
                }
            } else {
                error_log("DerivacionController - No hay última actualización, considerando todas como nuevas");
                // Si no hay última actualización, considerar todas como nuevas
                foreach ($derivacionesRecibidas as $derivacion) {
                    $nuevasDerivaciones[] = [
                        'patientName' => $derivacion['patientName'],
                        'usuario_origen_nombre' => $derivacion['usuario_origen_nombre'],
                        'studyDescription' => $derivacion['studyDescription'] ?? 'No especificado'
                    ];
                }
            }
            
            // Log para debugging
            error_log("DerivacionController - Nuevas derivaciones encontradas: " . count($nuevasDerivaciones));
            if (!empty($nuevasDerivaciones)) {
                error_log("DerivacionController - Detalles de nuevas derivaciones: " . print_r($nuevasDerivaciones, true));
            }
            
            echo json_encode([
                'success' => true,
                'derivacionesEnviadas' => $derivacionesEnviadas,
                'derivacionesRecibidas' => $derivacionesRecibidas,
                'nuevasDerivaciones' => $nuevasDerivaciones
            ]);
            break;
            
        case 'obtener_derivaciones_ocultas':
            $usuarioId = $_SESSION['id'];
            
            // Obtener derivaciones ocultas por el usuario
            $consultaOcultas = "SELECT d.*, u.nombre as usuario_origen_nombre, u.email as usuario_origen_email 
                               FROM derivaciones d 
                               JOIN usuarios u ON d.usuario_origen_id = u.id 
                               WHERE d.usuario_destino_id = $usuarioId AND d.activo = 1 
                               AND d.oculta_por_usuario IS NOT NULL AND JSON_CONTAINS(d.oculta_por_usuario, CAST($usuarioId AS JSON)) = 1
                               ORDER BY d.fecha_derivacion DESC";
            $resultadoOcultas = $conexion->query($consultaOcultas);
            
            $derivacionesOcultas = [];
            while ($row = $resultadoOcultas->fetch_assoc()) {
                $infoEstudio = obtenerInfoEstudioController($row['study_instance_uid']);
                $row['patientName'] = $infoEstudio['patientName'] ?? 'No disponible';
                $row['studyDate'] = $infoEstudio['studyDate'] ?? 'No disponible';
                $row['studyDescription'] = $infoEstudio['studyDescription'] ?? 'No disponible';
                $derivacionesOcultas[] = $row;
            }
            
            echo json_encode([
                'success' => true,
                'derivacionesOcultas' => $derivacionesOcultas
            ]);
            break;
            
        case 'marcar_vista':
            $usuarioId = $_SESSION['id'];
            if (isset($_POST['derivacion_id'])) {
                $derivacionId = (int)$_POST['derivacion_id'];
                
                $consulta = "UPDATE derivaciones SET vista = 1, fecha_vista = NOW() WHERE id = $derivacionId AND usuario_destino_id = $usuarioId";
                $resultado = $conexion->query($consulta);
                
                if ($resultado) {
                    echo json_encode(['success' => true, 'message' => 'Derivación marcada como vista']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al marcar como vista']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'ID de derivación no válido']);
            }
            break;
            
        case 'marcar_descargada':
            $usuarioId = $_SESSION['id'];
            if (isset($_POST['derivacion_id'])) {
                $derivacionId = (int)$_POST['derivacion_id'];
                
                $consulta = "UPDATE derivaciones SET descargada = 1, fecha_descarga = NOW() WHERE id = $derivacionId AND usuario_destino_id = $usuarioId";
                $resultado = $conexion->query($consulta);
                
                if ($resultado) {
                    echo json_encode(['success' => true, 'message' => 'Derivación marcada como descargada']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al marcar como descargada']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'ID de derivación no válido']);
            }
            break;
    }
}

$conexion->cerrar();
?>