<?php
session_start();
if(!isset($_SESSION['cargo']) || $_SESSION['cargo'] != 2){
    header('location: ../../index.php');
    exit();
}

$studyInstanceUID = $_GET['study'] ?? '';
if (empty($studyInstanceUID)) {
    die("UID de estudio no proporcionado");
}

$username = "iset";
$password = "iset";

// URL base del servidor de visualización
$baseUrl = "http://iset.portalpaciente.com.ar:3000";

// Inicializar cURL
$ch = curl_init();

// Configurar opciones de cURL para la autenticación inicial
curl_setopt($ch, CURLOPT_URL, $baseUrl);
curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);  // HEAD request
curl_setopt($ch, CURLOPT_COOKIEJAR, "cookies.txt");  // Guardar cookies

// Ejecutar la solicitud de autenticación
$response = curl_exec($ch);

// Verificar si la autenticación fue exitosa
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if ($httpCode == 200 || $httpCode == 302) {
    // La autenticación fue exitosa, ahora redirigimos al usuario
    $viewerUrl = "{$baseUrl}/viewer/{$studyInstanceUID}";
    
    // Configurar opciones de cURL para la redirección
    curl_setopt($ch, CURLOPT_URL, $viewerUrl);
    curl_setopt($ch, CURLOPT_COOKIEFILE, "cookies.txt");  // Usar cookies guardadas
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_NOBODY, false);  // GET request

    // Ejecutar la solicitud de redirección
    $response = curl_exec($ch);

    // Extraer todas las cookies de la respuesta
    preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $response, $matches);
    $cookies = array();
    foreach($matches[1] as $item) {
        parse_str($item, $cookie);
        $cookies = array_merge($cookies, $cookie);
    }

    // Cerrar cURL
    curl_close($ch);

    // Establecer las cookies en el navegador del cliente
    foreach($cookies as $name => $value) {
        setcookie($name, $value, 0, '/', 'iset.portalpaciente.com.ar');
    }

    // Redirigir al usuario al visor
    header("Location: $viewerUrl");
    exit();
} else {
    // La autenticación falló
    curl_close($ch);
    die("Error de autenticación con el servidor de visualización");
}
?>