<?php
session_start();

// Validamos que exista una session y ademas que el cargo que exista sea igual a 2 (Profesional)
if(!isset($_SESSION['cargo']) || $_SESSION['cargo'] != 2){
    header('location: ../../index.php');
}

$refphysician = $_SESSION['nombre'];

// Credenciales
$username = "iset";
$password = "iset";

// Datos de la solicitud
$url = "http://iset.portalpaciente.com.ar:8042/tools/find";
$data = json_encode([
    "Level" => "Study",
    "Query" => [
        "ReferringPhysicianName" => $_SESSION['nombre']
    ],
    "Expand" => true
]);

// Inicializar cURL
$ch = curl_init();

// Configurar opciones de cURL
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json"
]);

// Ejecutar la solicitud y obtener la respuesta
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo 'Error en la solicitud: ' . curl_error($ch);
} else {
    // Decodificar la respuesta JSON
    $jsonData = json_decode($response, true);

    if ($jsonData === null) {
        echo "Error al decodificar el JSON";
    } else {
        // Verificar si hay al menos un estudio en los resultados
        if (count($jsonData) > 0) {
            // Obtener el parámetro de ordenamiento
            $sortColumn = isset($_GET['sort']) ? $_GET['sort'] : 'PatientName';
            $sortOrder = isset($_GET['order']) && strtolower($_GET['order']) === 'desc' ? SORT_DESC : SORT_ASC;

            // Crear un array para ordenamiento
            $sortArray = array();
            foreach ($jsonData as $key => $study) {
                switch ($sortColumn) {
                    case 'PatientName':
                        $sortArray[$key] = $study['PatientMainDicomTags']['PatientName'];
                        break;
                    case 'PatientID':
                        $sortArray[$key] = $study['PatientMainDicomTags']['PatientID'];
                        break;
                    case 'StudyDescription':
                        $sortArray[$key] = $study['MainDicomTags']['StudyDescription'];
                        break;
                    case 'StudyDate':
                        $sortArray[$key] = $study['MainDicomTags']['StudyDate'];
                        break;
                    default:
                        $sortArray[$key] = $study['PatientMainDicomTags']['PatientName'];
                }
            }

            // Ordenar el array
            array_multisort($sortArray, $sortOrder, $jsonData);

            echo '<!DOCTYPE html>
            <html>
            <head>
                <meta charset="utf-8">
                <title>ISET-PROFESIONALES</title>
                <style>
                    table { border-collapse: collapse; width: 100%; }
                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                    th { background-color: #f2f2f2; cursor: pointer; }
                </style>
            </head>
            <body>';

            echo "Hola estimado colega " . strtoupper($_SESSION['nombre']) . ". Estos son los estudios de tus pacientes, solicitados a ISET:";
            echo '<a href="../../controller/cerrarSesion.php"><button type="button" name="button">Cerrar sesion</button></a>';

            echo "<h3>Estudios:</h3>";
            echo "<table>";
            echo "<tr>
                <th><a href='?sort=PatientName&order=" . ($sortColumn == 'PatientName' && $sortOrder == SORT_ASC ? 'desc' : 'asc') . "'>NOMBRE</a></th>
                <th><a href='?sort=PatientID&order=" . ($sortColumn == 'PatientID' && $sortOrder == SORT_ASC ? 'desc' : 'asc') . "'>ID</a></th>
                <th><a href='?sort=StudyDescription&order=" . ($sortColumn == 'StudyDescription' && $sortOrder == SORT_ASC ? 'desc' : 'asc') . "'>DESCRIPCION</a></th>
                <th><a href='?sort=StudyDate&order=" . ($sortColumn == 'StudyDate' && $sortOrder == SORT_ASC ? 'desc' : 'asc') . "'>FECHA</a></th>
                <th>ACCIONES</th>
            </tr>";

            foreach ($jsonData as $study) {
                echo "<tr>";
                $patientName = str_replace("^", " ", $study['PatientMainDicomTags']['PatientName'] ?? '');
                $patientid = str_replace("^", " ", $study['PatientMainDicomTags']['PatientID'] ?? '');
                $studydescription = str_replace("^", " ", $study['MainDicomTags']['StudyDescription'] ?? '');
                echo "<td>" . $patientName . "</td>";
                echo "<td>" . $patientid . "</td>";
                echo "<td>" . ($studydescription ?: 'No disponible') . "</td>";
                echo "<td>" . date("d/m/Y", strtotime($study['MainDicomTags']['StudyDate'])) . "</td>";
                echo "<td>";
                echo "<a href='download.php?study=" . $study['ID'] . "'><i class='fas fa-download'></i> Descargar</a> | ";
                echo "<a href='view.php?study=" . $study['MainDicomTags']['StudyInstanceUID'] . "' target='_blank' rel='noopener noreferrer'><i class='fas fa-eye'></i> Visualizar</a>";
                echo "</td>";
                echo "</tr>";
            }

            echo "</table>";
            echo '</body></html>';
        } else {
            echo "No se encontraron estudios para el paciente.";
        }
    }
}
// Cerrar cURL
curl_close($ch);
?>