<?php
session_start();
if(!isset($_SESSION['cargo']) || $_SESSION['cargo'] != 2){
    header('location: ../../index.php');
    exit();
}

$studyInstanceUID = $_GET['study'] ?? '';
if (empty($studyInstanceUID)) {
    die("ID de estudio no proporcionado");
}

// Función para obtener información del estudio
function obtenerInfoEstudio($studyInstanceUID) {
    $url = "https://iset.portalpaciente.com.ar/api/find";
    $data = json_encode([
        "Level" => "Study",
        "Query" => [
            "StudyInstanceUID" => $studyInstanceUID
        ],
        "Expand" => true
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        error_log('Error cURL en obtenerInfoEstudio: ' . curl_error($ch));
        curl_close($ch);
        return null;
    }
    
    curl_close($ch);
    
    $jsonData = json_decode($response, true);
    
    if ($jsonData && count($jsonData) > 0) {
        $study = $jsonData[0];
        return [
            'patientName' => str_replace("^", " ", $study['PatientMainDicomTags']['PatientName'] ?? ''),
            'studyDate' => $study['MainDicomTags']['StudyDate'] ?? '',
            'studyDescription' => str_replace("^", " ", $study['MainDicomTags']['StudyDescription'] ?? 'No disponible'),
            'studyID' => $study['ID'] ?? ''
        ];
    }
    
    return null;
}

// Función auxiliar para construir el nombre del archivo con formato: nombrepaciente_fechaestudio_descripcion.zip
function construirNombreArchivo($patientName, $studyDate, $studyDescription = 'No disponible') {
    // Limpiar nombre del paciente
    $safePatientName = preg_replace('/[^a-zA-Z0-9_-]/', '_', $patientName);
    
    // Formatear fecha: convertir YYYYMMDD a YYYYMMDD (mantener formato DICOM)
    $fechaFormateada = $studyDate;
    if (strlen($studyDate) == 8) {
        // Ya está en formato YYYYMMDD
        $fechaFormateada = $studyDate;
    } elseif (strtotime($studyDate)) {
        // Convertir a YYYYMMDD si viene en otro formato
        $fechaFormateada = date('Ymd', strtotime($studyDate));
    }
    
    // Limpiar descripción del estudio (reemplazar espacios y caracteres especiales)
    $safeDescription = preg_replace('/[^a-zA-Z0-9_-]/', '_', $studyDescription);
    // Limitar longitud para evitar nombres de archivo muy largos
    if (strlen($safeDescription) > 50) {
        $safeDescription = substr($safeDescription, 0, 50);
    }
    
    // Construir nombre: nombrepaciente_fechaestudio_descripcion.zip
    return "{$safePatientName}_{$fechaFormateada}_{$safeDescription}.zip";
}

// Obtener información del estudio
$infoEstudio = obtenerInfoEstudio($studyInstanceUID);

if (!$infoEstudio) {
    die("Error: No se pudo obtener la información del estudio");
}

$patientName = $infoEstudio['patientName'] ?? 'No disponible';
$studyDate = $infoEstudio['studyDate'] ?? '';
$studyDescription = $infoEstudio['studyDescription'] ?? 'No disponible';
$filename = construirNombreArchivo($patientName, $studyDate, $studyDescription);

// URL para la descarga del archivo usando API de dcm4chee-arc (isetarc)
$downloadUrl = "https://iset.portalpaciente.com.ar/api/isetarc/{$studyInstanceUID}?accept=application/zip&filename=" . urlencode($filename);

// Redirigir al usuario directamente a la URL de descarga
header("Location: " . $downloadUrl);
exit();
?>
