<?php
session_start();

// Validamos que exista una session y ademas que el cargo que exista sea igual a 0 (Root) o 1 (Administradores)
if(!isset($_SESSION['cargo']) || ($_SESSION['cargo'] != '0' && $_SESSION['cargo'] != '1')){
    header('location: ../../index.php');
    exit();
}

// Importar la clase Conexion
require_once('../../model/conexion.php');

// Inicializar variables
$mensaje = '';
$tipoMensaje = '';
$usuarios = [];

try {
    $conexion = new Conexion();
    $conexion->conectar();
    
    // Procesar acciones
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['action'])) {
            switch ($_POST['action']) {
                case 'create':
                    // Crear nuevo usuario
                    $nombre = $conexion->salvar($_POST['nombre']);
                    $email = $conexion->salvar($_POST['email']);
                    $clave = $conexion->salvar($_POST['clave']);
                    $cargo = $conexion->salvar($_POST['cargo']);
                    
                    // Validar permisos - solo root puede crear otros root
                    if ($cargo == '0' && $_SESSION['cargo'] != '0') {
                        $mensaje = 'No tienes permisos para crear usuarios root.';
                        $tipoMensaje = 'error';
                        break;
                    }
                    
                    // Validar que el email no exista
                    $verificarEmail = $conexion->verificarRegistros("SELECT id FROM usuarios WHERE email = '$email'");
                    
                    if ($verificarEmail > 0) {
                        $mensaje = 'El correo electrónico ya existe en el sistema.';
                        $tipoMensaje = 'error';
                    } else {
                        $claveHash = md5($clave);
                        $query = "INSERT INTO usuarios (nombre, email, clave, cargo) VALUES ('$nombre', '$email', '$claveHash', '$cargo')";
                        
                        if ($conexion->query($query)) {
                            $mensaje = 'Usuario creado exitosamente.';
                            $tipoMensaje = 'success';
                        } else {
                            $mensaje = 'Error al crear el usuario: ' . $conexion->error();
                            $tipoMensaje = 'error';
                        }
                    }
                    break;
                    
                case 'update':
                    // Actualizar usuario
                    $id = $conexion->salvar($_POST['id']);
                    $nombre = $conexion->salvar($_POST['nombre']);
                    $email = $conexion->salvar($_POST['email']);
                    $cargo = $conexion->salvar($_POST['cargo']);
                    
                    // Validar permisos - solo root puede cambiar a root
                    if ($cargo == '0' && $_SESSION['cargo'] != '0') {
                        $mensaje = 'No tienes permisos para asignar el rol de root.';
                        $tipoMensaje = 'error';
                        break;
                    }
                    
                    // Verificar si el email ya existe en otro usuario
                    $verificarEmail = $conexion->verificarRegistros("SELECT id FROM usuarios WHERE email = '$email' AND id != '$id'");
                    
                    if ($verificarEmail > 0) {
                        $mensaje = 'El correo electrónico ya existe en otro usuario.';
                        $tipoMensaje = 'error';
                    } else {
                        $query = "UPDATE usuarios SET nombre = '$nombre', email = '$email', cargo = '$cargo' WHERE id = '$id'";
                        
                        if ($conexion->query($query)) {
                            $mensaje = 'Usuario actualizado exitosamente.';
                            $tipoMensaje = 'success';
                        } else {
                            $mensaje = 'Error al actualizar el usuario: ' . $conexion->error();
                            $tipoMensaje = 'error';
                        }
                    }
                    break;
                    
                case 'delete':
                    // Eliminar usuario
                    $id = $conexion->salvar($_POST['id']);
                    
                    // No permitir eliminar el usuario actual
                    if ($id == $_SESSION['id']) {
                        $mensaje = 'No puedes eliminar tu propia cuenta.';
                        $tipoMensaje = 'error';
                    } else {
                        // Verificar si el usuario a eliminar es root y si el usuario actual tiene permisos
                        $resultadoUsuario = $conexion->query("SELECT cargo FROM usuarios WHERE id = '$id'");
                        if ($resultadoUsuario && $resultadoUsuario->num_rows > 0) {
                            $usuarioAEliminar = $resultadoUsuario->fetch_assoc();
                            if ($usuarioAEliminar['cargo'] == '0' && $_SESSION['cargo'] != '0') {
                                $mensaje = 'No tienes permisos para eliminar usuarios root.';
                                $tipoMensaje = 'error';
                            } else {
                                $query = "DELETE FROM usuarios WHERE id = '$id'";
                                
                                if ($conexion->query($query)) {
                                    $mensaje = 'Usuario eliminado exitosamente.';
                                    $tipoMensaje = 'success';
                                } else {
                                    $mensaje = 'Error al eliminar el usuario: ' . $conexion->error();
                                    $tipoMensaje = 'error';
                                }
                            }
                        } else {
                            $mensaje = 'Usuario no encontrado.';
                            $tipoMensaje = 'error';
                        }
                    }
                    break;
                    
                case 'reset_password':
                    // Resetear contraseña
                    $id = $conexion->salvar($_POST['id']);
                    $nuevaClave = $conexion->salvar($_POST['nueva_clave']);
                    $claveHash = md5($nuevaClave);
                    
                    $query = "UPDATE usuarios SET clave = '$claveHash' WHERE id = '$id'";
                    
                    if ($conexion->query($query)) {
                        $mensaje = 'Contraseña actualizada exitosamente.';
                        $tipoMensaje = 'success';
                    } else {
                        $mensaje = 'Error al actualizar la contraseña: ' . $conexion->error();
                        $tipoMensaje = 'error';
                    }
                    break;
            }
        }
    }
    
    // Obtener lista de usuarios
    $query = "SELECT id, nombre, email, cargo, 
              CASE 
                WHEN cargo = '0' THEN 'Root'
                WHEN cargo = '1' THEN 'Administrador'
                WHEN cargo = '2' THEN 'Usuario'
                ELSE 'Desconocido'
              END as cargo_nombre
              FROM usuarios ORDER BY cargo ASC, nombre ASC";
    
    $resultado = $conexion->query($query);
    
    if ($resultado) {
        while ($row = $resultado->fetch_assoc()) {
            $usuarios[] = $row;
        }
    }
    
} catch (Exception $e) {
    $mensaje = 'Error de conexión: ' . $e->getMessage();
    $tipoMensaje = 'error';
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administración de Usuarios - ISET</title>
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="../../css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="../../css/font-awesome.min.css">
    <!-- SweetAlert -->
    <link rel="stylesheet" href="../../css/sweetalert.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --secondary-color: #64748b;
            --accent-color: #f1f5f9;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --border-color: #e2e8f0;
            --success-color: #10b981;
            --error-color: #ef4444;
            --warning-color: #f59e0b;
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            margin: 0;
            padding: 20px;
            color: var(--text-primary);
            line-height: 1.6;
        }

        .admin-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .admin-card {
            background: white;
            border-radius: 16px;
            box-shadow: var(--shadow-lg);
            overflow: hidden;
            margin-bottom: 20px;
        }

        .admin-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 24px 32px;
            position: relative;
        }

        .admin-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }

        .admin-title {
            font-size: 24px;
            font-weight: 700;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        .admin-subtitle {
            font-size: 14px;
            opacity: 0.9;
            margin: 4px 0 0;
            position: relative;
            z-index: 1;
        }

        .admin-body {
            padding: 32px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            font-weight: 500;
            transition: all 0.3s ease;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .btn-success {
            background: linear-gradient(135deg, var(--success-color) 0%, #059669 100%);
            border: none;
            border-radius: 8px;
            padding: 8px 16px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-warning {
            background: linear-gradient(135deg, var(--warning-color) 0%, #d97706 100%);
            border: none;
            border-radius: 8px;
            padding: 8px 16px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-danger {
            background: linear-gradient(135deg, var(--error-color) 0%, #dc2626 100%);
            border: none;
            border-radius: 8px;
            padding: 8px 16px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            border-radius: 6px;
            min-width: 32px;
            height: 32px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white !important;
            text-decoration: none;
            border: none;
            cursor: pointer;
        }

        .btn-group {
            display: flex;
            gap: 4px;
            flex-wrap: nowrap;
        }

        .btn-group .btn {
            margin: 0;
            flex-shrink: 0;
        }

        .btn-warning.btn-sm {
            background: linear-gradient(135deg, var(--warning-color) 0%, #d97706 100%);
            color: white;
        }

        .btn-success.btn-sm {
            background: linear-gradient(135deg, var(--success-color) 0%, #059669 100%);
            color: white;
        }

        .btn-danger.btn-sm {
            background: linear-gradient(135deg, var(--error-color) 0%, #dc2626 100%);
            color: white;
        }

        .btn-warning.btn-sm:hover,
        .btn-success.btn-sm:hover,
        .btn-danger.btn-sm:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
            color: white;
        }

        /* Ensure buttons are visible */
        .table .btn {
            display: inline-flex !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        .table .btn-group {
            display: flex !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        /* Fix for button spacing */
        .btn-group > .btn:not(:first-child):not(:last-child) {
            border-radius: 6px;
        }

        .btn-group > .btn:first-child {
            border-radius: 6px 0 0 6px;
        }

        .btn-group > .btn:last-child {
            border-radius: 0 6px 6px 0;
        }

        .table {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: var(--shadow-sm);
        }

        .table thead th {
            background: var(--accent-color);
            border: none;
            font-weight: 600;
            color: var(--text-primary);
            padding: 16px;
        }

        .table tbody td {
            border: none;
            border-bottom: 1px solid var(--border-color);
            padding: 16px;
            vertical-align: middle;
        }

        .table tbody td:last-child {
            text-align: center;
            min-width: 120px;
        }

        .table tbody tr:hover {
            background: var(--accent-color);
        }

        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 500;
            font-size: 12px;
        }

        .badge-admin {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
        }

        .badge-user {
            background: linear-gradient(135deg, var(--secondary-color) 0%, #475569 100%);
            color: white;
        }

        .badge-root {
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
            color: white;
        }

        .modal-content {
            border-radius: 16px;
            border: none;
            box-shadow: var(--shadow-lg);
        }

        .modal-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            border-radius: 16px 16px 0 0;
            border: none;
        }

        .modal-title {
            font-weight: 600;
        }

        .form-control {
            border: 2px solid var(--border-color);
            border-radius: 8px;
            padding: 12px 16px;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .alert {
            border-radius: 8px;
            border: none;
            padding: 16px;
        }

        .alert-success {
            background: linear-gradient(135deg, var(--success-color) 0%, #059669 100%);
            color: white;
        }

        .alert-danger {
            background: linear-gradient(135deg, var(--error-color) 0%, #dc2626 100%);
            color: white;
        }

        .stats-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: var(--shadow-sm);
            margin-bottom: 24px;
        }

        .stats-number {
            font-size: 32px;
            font-weight: 700;
            color: var(--primary-color);
        }

        .stats-label {
            color: var(--text-secondary);
            font-size: 14px;
            margin-top: 4px;
        }

        .search-container {
            min-width: 300px;
            display: flex;
            flex-direction: column;
            align-items: stretch;
        }

        .search-container .input-group {
            box-shadow: var(--shadow-sm);
            border-radius: 8px;
            overflow: hidden;
            background: white;
            height: 48px;
            display: flex;
            align-items: stretch;
        }

        .search-container .input-group-text {
            background: var(--accent-color);
            border: 2px solid var(--border-color);
            border-right: none;
            color: var(--text-secondary);
            border-radius: 8px 0 0 8px;
            padding: 12px 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 48px;
            flex-shrink: 0;
        }

        .search-container .form-control {
            border: 2px solid var(--border-color);
            border-left: none;
            border-radius: 0 8px 8px 0;
            padding: 12px 16px;
            transition: all 0.3s ease;
            background: white;
            height: 100%;
            line-height: 1.5;
            flex: 1;
        }

        .search-container .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
            background: white;
        }

        .search-container .form-control:focus + .input-group-text {
            border-color: var(--primary-color);
        }

        .search-container .input-group-text:hover {
            background: var(--primary-color);
            color: white;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .search-container small {
            margin-left: 4px;
            font-size: 12px;
            margin-top: 4px;
        }

        .table-row {
            transition: all 0.3s ease;
        }

        .table-row.hidden {
            display: none !important;
        }

        .no-results {
            text-align: center;
            padding: 40px 20px;
            color: var(--text-secondary);
        }

        .no-results i {
            font-size: 48px;
            margin-bottom: 16px;
            opacity: 0.5;
        }

        .no-results h4 {
            margin-bottom: 8px;
            color: var(--text-primary);
        }

        .no-results p {
            margin: 0;
            font-size: 14px;
        }

        @media (max-width: 768px) {
            .admin-body {
                padding: 20px;
            }
            
            .table-responsive {
                border-radius: 12px;
            }

            .search-container {
                min-width: 100%;
                margin-bottom: 15px;
            }

            .d-flex.align-items-center.gap-3 {
                flex-direction: column;
                align-items: stretch !important;
                gap: 15px !important;
            }

            .search-container .input-group {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <!-- Header -->
        <div class="admin-card">
            <div class="admin-header">
                <h1 class="admin-title">
                    <i class="fa fa-users"></i> Administración de Usuarios
                </h1>
                <p class="admin-subtitle">Gestiona las cuentas de usuarios del sistema ISET</p>
            </div>
            
            <div class="admin-body">
                <!-- Navigation -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <a href="index.php" class="btn btn-secondary">
                            <i class="fa fa-arrow-left"></i> Volver al Panel
                        </a>
                    </div>
                    <div class="d-flex align-items-center" style="gap: 16px;">
                        <!-- Search Box -->
                        <div class="search-container">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fa fa-search"></i>
                                    </span>
                                </div>
                                <input type="text" class="form-control" id="searchInput" placeholder="Buscar usuarios..." style="border-radius: 0 8px 8px 0;">
                            </div>
                            <small class="text-muted mt-1" id="searchResults" style="display: none;">
                                <span id="resultsCount">0</span> resultado(s) encontrado(s)
                            </small>
                        </div>
                        <button class="btn btn-primary" data-toggle="modal" data-target="#createUserModal">
                            <i class="fa fa-plus"></i> Nuevo Usuario
                        </button>
                    </div>
                </div>

                <!-- Stats -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="stats-card">
                            <div class="stats-number"><?php echo count($usuarios); ?></div>
                            <div class="stats-label">Total Usuarios</div>
                        </div>
                    </div>
                    <?php if ($_SESSION['cargo'] == '0'): ?>
                    <div class="col-md-3">
                        <div class="stats-card">
                            <div class="stats-number"><?php echo count(array_filter($usuarios, function($u) { return $u['cargo'] == '0'; })); ?></div>
                            <div class="stats-label">Root</div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-3">
                        <div class="stats-card">
                            <div class="stats-number"><?php echo count(array_filter($usuarios, function($u) { return $u['cargo'] == '1'; })); ?></div>
                            <div class="stats-label">Administradores</div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stats-card">
                            <div class="stats-number"><?php echo count(array_filter($usuarios, function($u) { return $u['cargo'] == '2'; })); ?></div>
                            <div class="stats-label">Usuarios</div>
                        </div>
                    </div>
                </div>

                <!-- Messages -->
                <?php if ($mensaje): ?>
                    <div class="alert alert-<?php echo $tipoMensaje === 'success' ? 'success' : 'danger'; ?> alert-dismissible fade show" role="alert">
                        <?php echo $mensaje; ?>
                        <button type="button" class="close" data-dismiss="alert">
                            <span>&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <!-- Users Table -->
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Email</th>
                                <th>Cargo</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($usuarios)): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">
                                        <i class="fa fa-users fa-2x mb-2"></i><br>
                                        No hay usuarios registrados
                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($usuarios as $usuario): ?>
                                    <?php 
                                    // Determinar qué información incluir en la búsqueda según los permisos
                                    if ($_SESSION['cargo'] == '0' || $usuario['cargo'] != '0') {
                                        $searchData = strtolower(htmlspecialchars($usuario['nombre'] . ' ' . $usuario['email'] . ' ' . $usuario['cargo_nombre']));
                                    } else {
                                        // Para usuarios no-root que intentan ver usuarios root, solo incluir información básica
                                        $searchData = strtolower(htmlspecialchars('[Información Restringida] ' . $usuario['cargo_nombre']));
                                    }
                                    ?>
                                    <tr class="table-row" data-search="<?php echo $searchData; ?>">
                                        <td><?php echo $usuario['id']; ?></td>
                                        <td>
                                            <?php if ($_SESSION['cargo'] == '0' || $usuario['cargo'] != '0'): ?>
                                                <strong><?php echo htmlspecialchars($usuario['nombre']); ?></strong>
                                                <?php if ($usuario['id'] == $_SESSION['id']): ?>
                                                    <span class="badge badge-info ml-2">Tú</span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <!-- Para usuarios no-root que intentan ver usuarios root, mostrar información limitada -->
                                                <strong style="color: #6c757d;">[Información Restringida]</strong>
                                                <span class="badge badge-secondary ml-2">Root</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($_SESSION['cargo'] == '0' || $usuario['cargo'] != '0'): ?>
                                                <?php echo htmlspecialchars($usuario['email']); ?>
                                            <?php else: ?>
                                                <!-- Para usuarios no-root que intentan ver usuarios root, mostrar información limitada -->
                                                <span style="color: #6c757d;">[Email Restringido]</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge <?php echo $usuario['cargo'] == '1' ? 'badge-admin' : ($usuario['cargo'] == '0' ? 'badge-root' : 'badge-user'); ?>">
                                                <?php echo $usuario['cargo_nombre']; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group" style="display: flex !important; gap: 4px;">
                                                <?php if ($_SESSION['cargo'] == '0' || $usuario['cargo'] != '0'): ?>
                                                    <button type="button" class="btn btn-warning btn-sm" onclick="editUser(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre']); ?>', '<?php echo htmlspecialchars($usuario['email']); ?>', '<?php echo $usuario['cargo']; ?>')" style="display: inline-flex !important;">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-success btn-sm" onclick="resetPassword(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre']); ?>')" style="display: inline-flex !important;">
                                                        <i class="fa fa-key"></i>
                                                    </button>
                                                <?php else: ?>
                                                    <!-- Para usuarios no-root que intentan ver usuarios root, mostrar botones deshabilitados -->
                                                    <button type="button" class="btn btn-warning btn-sm" disabled style="display: inline-flex !important; opacity: 0.5; cursor: not-allowed;" title="No tienes permisos para editar usuarios root">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-success btn-sm" disabled style="display: inline-flex !important; opacity: 0.5; cursor: not-allowed;" title="No tienes permisos para resetear contraseña de usuarios root">
                                                        <i class="fa fa-key"></i>
                                                    </button>
                                                <?php endif; ?>
                                                <?php if ($usuario['id'] != $_SESSION['id'] && ($_SESSION['cargo'] == '0' || $usuario['cargo'] != '0')): ?>
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteUser(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre']); ?>')" style="display: inline-flex !important;">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    
                    <!-- No Results Message -->
                    <div id="noResults" class="no-results" style="display: none;">
                        <i class="fa fa-search"></i>
                        <h4>No se encontraron resultados</h4>
                        <p>Intenta con otros términos de búsqueda</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create User Modal -->
    <div class="modal fade" id="createUserModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fa fa-user-plus"></i> Nuevo Usuario
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <input type="hidden" name="action" value="create">
                        
                        <div class="form-group">
                            <label for="nombre">Nombre Completo</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">Correo Electrónico</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="clave">Contraseña</label>
                            <input type="password" class="form-control" id="clave" name="clave" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="cargo">Cargo</label>
                            <select class="form-control" id="cargo" name="cargo" required>
                                <option value="2">Usuario</option>
                                <option value="1">Administrador</option>
                                <?php if ($_SESSION['cargo'] == '0'): ?>
                                    <option value="0">Root</option>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Crear Usuario</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit User Modal -->
    <div class="modal fade" id="editUserModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fa fa-edit"></i> Editar Usuario
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <input type="hidden" name="action" value="update">
                        <input type="hidden" name="id" id="edit_id">
                        
                        <div class="form-group">
                            <label for="edit_nombre">Nombre Completo</label>
                            <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="edit_email">Correo Electrónico</label>
                            <input type="email" class="form-control" id="edit_email" name="email" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="edit_cargo">Cargo</label>
                            <select class="form-control" id="edit_cargo" name="cargo" required>
                                <option value="2">Usuario</option>
                                <option value="1">Administrador</option>
                                <?php if ($_SESSION['cargo'] == '0'): ?>
                                    <option value="0">Root</option>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Actualizar Usuario</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reset Password Modal -->
    <div class="modal fade" id="resetPasswordModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fa fa-key"></i> Resetear Contraseña
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <input type="hidden" name="action" value="reset_password">
                        <input type="hidden" name="id" id="reset_id">
                        
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i>
                            Se generará una nueva contraseña para el usuario: <strong id="reset_user_name"></strong>
                        </div>
                        
                        <div class="form-group">
                            <label for="nueva_clave">Nueva Contraseña</label>
                            <input type="password" class="form-control" id="nueva_clave" name="nueva_clave" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Actualizar Contraseña</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../../js/jquery.js"></script>
    <script src="../../js/bootstrap.min.js"></script>
    <script src="../../js/sweetalert.min.js"></script>
    
    <script>
        function editUser(id, nombre, email, cargo) {
            // Verificar si el usuario actual tiene permisos para editar usuarios root
            const currentUserCargo = '<?php echo $_SESSION['cargo']; ?>';
            
            if (cargo === '0' && currentUserCargo !== '0') {
                swal('Error', 'No tienes permisos para editar usuarios root.', 'error');
                return;
            }
            
            document.getElementById('edit_id').value = id;
            document.getElementById('edit_nombre').value = nombre;
            document.getElementById('edit_email').value = email;
            document.getElementById('edit_cargo').value = cargo;
            $('#editUserModal').modal('show');
        }

        function resetPassword(id, nombre) {
            // Verificar si el usuario actual tiene permisos para resetear contraseña de usuarios root
            const currentUserCargo = '<?php echo $_SESSION['cargo']; ?>';
            const row = $(`tr[data-search*="${nombre}"]`);
            const badge = row.find('td:nth-child(4) .badge');
            
            if (badge.hasClass('badge-root') && currentUserCargo !== '0') {
                swal('Error', 'No tienes permisos para resetear la contraseña de usuarios root.', 'error');
                return;
            }
            
            document.getElementById('reset_id').value = id;
            document.getElementById('reset_user_name').textContent = nombre;
            $('#resetPasswordModal').modal('show');
        }

        function deleteUser(id, nombre) {
            // Verificar si el usuario actual tiene permisos para eliminar usuarios root
            const currentUserCargo = '<?php echo $_SESSION['cargo']; ?>';
            const row = $(`tr[data-search*="${nombre}"]`);
            const badge = row.find('td:nth-child(4) .badge');
            
            if (badge.hasClass('badge-root') && currentUserCargo !== '0') {
                swal('Error', 'No tienes permisos para eliminar usuarios root.', 'error');
                return;
            }
            
            swal({
                title: "¿Estás seguro?",
                text: `¿Realmente quieres eliminar al usuario "${nombre}"? Esta acción no se puede deshacer.`,
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Sí, eliminar",
                cancelButtonText: "Cancelar"
            }, function(isConfirm) {
                if (isConfirm) {
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.innerHTML = `
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="${id}">
                    `;
                    document.body.appendChild(form);
                    form.submit();
                }
            });
        }

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);

        // Search functionality
        $(document).ready(function() {
            const searchInput = $('#searchInput');
            const searchResults = $('#searchResults');
            const resultsCount = $('#resultsCount');
            const tableRows = $('.table-row');
            const noResults = $('#noResults');
            const tableBody = $('tbody');
            let searchTimeout;

            // Store original content for restoration
            const originalContent = {};
            tableRows.each(function() {
                const row = $(this);
                const rowId = row.find('td:first').text();
                originalContent[rowId] = row.html();
            });

            // Use event delegation for button clicks
            $(document).on('click', '.btn-warning', function(e) {
                e.preventDefault();
                
                // Verificar si el botón está deshabilitado
                if ($(this).prop('disabled')) {
                    swal('Error', 'No tienes permisos para editar usuarios root.', 'error');
                    return;
                }
                
                const row = $(this).closest('tr');
                const userId = row.find('td:first').text();
                const userName = row.find('td:nth-child(2) strong').text();
                const userEmail = row.find('td:nth-child(3)').text();
                const badge = row.find('td:nth-child(4) .badge');
                let userCargo = '2';
                if (badge.hasClass('badge-root')) {
                    userCargo = '0';
                } else if (badge.hasClass('badge-admin')) {
                    userCargo = '1';
                }
                editUser(userId, userName, userEmail, userCargo);
            });

            $(document).on('click', '.btn-success', function(e) {
                e.preventDefault();
                
                // Verificar si el botón está deshabilitado
                if ($(this).prop('disabled')) {
                    swal('Error', 'No tienes permisos para resetear la contraseña de usuarios root.', 'error');
                    return;
                }
                
                const row = $(this).closest('tr');
                const userId = row.find('td:first').text();
                const userName = row.find('td:nth-child(2) strong').text();
                resetPassword(userId, userName);
            });

            $(document).on('click', '.btn-danger', function(e) {
                e.preventDefault();
                const row = $(this).closest('tr');
                const userId = row.find('td:first').text();
                const userName = row.find('td:nth-child(2) strong').text();
                deleteUser(userId, userName);
            });

            searchInput.on('input', function() {
                const searchTerm = $(this).val().toLowerCase().trim();
                
                // Clear previous timeout
                clearTimeout(searchTimeout);
                
                // Add a small delay for better performance
                searchTimeout = setTimeout(function() {
                    performSearch(searchTerm);
                }, 300);
            });

            function performSearch(searchTerm) {
                if (searchTerm === '') {
                    // Show all rows when search is empty
                    tableRows.removeClass('hidden');
                    noResults.hide();
                    tableBody.show();
                    resultsCount.text('0');
                    searchResults.hide();
                    
                    // Restore original content to preserve buttons and design
                    tableRows.each(function() {
                        const row = $(this);
                        const rowId = row.find('td:first').text();
                        if (originalContent[rowId]) {
                            row.html(originalContent[rowId]);
                        }
                    });
                    return;
                }

                let visibleCount = 0;
                
                tableRows.each(function() {
                    const row = $(this);
                    const searchData = row.data('search') || '';
                    
                    if (searchData.includes(searchTerm)) {
                        row.removeClass('hidden');
                        visibleCount++;
                        
                        // Highlight search terms in visible rows, but preserve buttons and respect permissions
                        row.find('td').each(function() {
                            const $td = $(this);
                            const $buttons = $td.find('.btn-group');
                            
                            // Skip cells that contain buttons
                            if ($buttons.length > 0) {
                                return;
                            }
                            
                            // Skip highlighting for restricted information
                            const text = $td.text();
                            if (text.includes('[Información Restringida]') || text.includes('[Email Restringido]')) {
                                return;
                            }
                            
                            const highlightedText = text.replace(
                                new RegExp(searchTerm, 'gi'),
                                '<mark style="background-color: #fef08a; padding: 2px 4px; border-radius: 4px;">$&</mark>'
                            );
                            if (highlightedText !== text) {
                                $td.html(highlightedText);
                            }
                        });
                    } else {
                        row.addClass('hidden');
                    }
                });

                // Show/hide no results message
                if (visibleCount === 0) {
                    tableBody.hide();
                    noResults.show();
                    resultsCount.text('0');
                    searchResults.hide();
                } else {
                    tableBody.show();
                    noResults.hide();
                    resultsCount.text(visibleCount);
                    searchResults.show();
                }
            }

            // Clear search when clicking the search icon
            $('.input-group-text').on('click', function() {
                searchInput.val('').trigger('input');
                searchInput.focus();
            });

            // Clear search on escape key
            searchInput.on('keydown', function(e) {
                if (e.key === 'Escape') {
                    $(this).val('').trigger('input');
                }
            });

            // Focus search input on page load
            searchInput.focus();
        });
    </script>
</body>
</html>
