<?php
session_start();

// Verificar si el usuario está logueado y es admin
if (!isset($_SESSION['cargo']) || $_SESSION['cargo'] != 1) {
    die('Acceso denegado. Solo administradores pueden ejecutar este script.');
}

require_once('../../model/conexion.php');

echo "<h2>Test de Derivaciones - Admin Panel</h2>";
echo "<hr>";

// Crear conexión
$conexion = new Conexion();

try {
    $conexion->conectar();
    echo "<p style='color: green;'>✅ Conexión a base de datos exitosa</p>";
    
    $usuarioId = $_SESSION['id'];
    echo "<p><strong>Usuario Admin ID:</strong> $usuarioId</p>";
    
    // 1. Verificar tabla derivaciones
    echo "<h3>1. Verificando tabla derivaciones</h3>";
    $checkTable = "SHOW TABLES LIKE 'derivaciones'";
    $result = $conexion->query($checkTable);
    
    if ($result && $result->num_rows > 0) {
        echo "<p style='color: green;'>✅ Tabla 'derivaciones' existe</p>";
        
        // Verificar estructura
        $structure = $conexion->query("DESCRIBE derivaciones");
        echo "<h4>Estructura de la tabla:</h4>";
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($row = $structure->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['Field']}</td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
    } else {
        echo "<p style='color: red;'>❌ Tabla 'derivaciones' NO existe</p>";
    }
    
    // 2. Verificar datos existentes
    echo "<h3>2. Verificando datos existentes</h3>";
    $countTotal = $conexion->query("SELECT COUNT(*) as total FROM derivaciones");
    $totalRows = $countTotal->fetch_assoc()['total'];
    echo "<p><strong>Total de derivaciones en la tabla:</strong> $totalRows</p>";
    
    // 3. Probar consultas de admin/index.php
    echo "<h3>3. Probando consultas de admin/index.php</h3>";
    
    // Consulta de derivaciones enviadas (por el admin actual)
    echo "<h4>Derivaciones Enviadas (por admin actual):</h4>";
    $consultaEnviadas = "SELECT d.id, d.study_instance_uid, d.usuario_origen_id, d.usuario_destino_id, 
                        d.fecha_derivacion, d.activo, d.comentario, 
                        COALESCE(d.vista, 0) as vista, COALESCE(d.descargada, 0) as descargada,
                        d.fecha_vista, d.fecha_descarga,
                        u.nombre as usuario_destino_nombre, u.email as usuario_destino_email 
                        FROM derivaciones d 
                        JOIN usuarios u ON d.usuario_destino_id = u.id 
                        WHERE d.usuario_origen_id = $usuarioId AND d.activo = 1 
                        ORDER BY d.fecha_derivacion DESC";
    
    echo "<p><strong>Consulta SQL:</strong></p>";
    echo "<pre>" . htmlspecialchars($consultaEnviadas) . "</pre>";
    
    $resultEnviadas = $conexion->query($consultaEnviadas);
    if ($resultEnviadas) {
        echo "<p style='color: green;'>✅ Consulta ejecutada exitosamente</p>";
        echo "<p><strong>Filas encontradas:</strong> " . $resultEnviadas->num_rows . "</p>";
        
        if ($resultEnviadas->num_rows > 0) {
            echo "<table border='1' style='border-collapse: collapse;'>";
            echo "<tr><th>ID</th><th>Study UID</th><th>Destino</th><th>Fecha</th><th>Comentario</th></tr>";
            while ($row = $resultEnviadas->fetch_assoc()) {
                echo "<tr>";
                echo "<td>{$row['id']}</td>";
                echo "<td>" . substr($row['study_instance_uid'], 0, 30) . "...</td>";
                echo "<td>{$row['usuario_destino_nombre']}</td>";
                echo "<td>{$row['fecha_derivacion']}</td>";
                echo "<td>{$row['comentario']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "<p style='color: red;'>❌ Error en consulta: " . $conexion->error() . "</p>";
    }
    
    // Consulta de derivaciones realizadas (todas en el sistema)
    echo "<h4>Derivaciones Realizadas (todas en el sistema):</h4>";
    $consultaRealizadas = "SELECT d.id, d.study_instance_uid, d.usuario_origen_id, d.usuario_destino_id, 
                          d.fecha_derivacion, d.activo, d.comentario, 
                          COALESCE(d.vista, 0) as vista, COALESCE(d.descargada, 0) as descargada,
                          d.fecha_vista, d.fecha_descarga,
                          u_origen.nombre as usuario_origen_nombre, u_origen.email as usuario_origen_email,
                          u_destino.nombre as usuario_destino_nombre, u_destino.email as usuario_destino_email
                          FROM derivaciones d 
                          JOIN usuarios u_origen ON d.usuario_origen_id = u_origen.id 
                          JOIN usuarios u_destino ON d.usuario_destino_id = u_destino.id 
                          WHERE d.activo = 1 
                          ORDER BY d.fecha_derivacion DESC";
    
    echo "<p><strong>Consulta SQL:</strong></p>";
    echo "<pre>" . htmlspecialchars($consultaRealizadas) . "</pre>";
    
    $resultRealizadas = $conexion->query($consultaRealizadas);
    if ($resultRealizadas) {
        echo "<p style='color: green;'>✅ Consulta ejecutada exitosamente</p>";
        echo "<p><strong>Filas encontradas:</strong> " . $resultRealizadas->num_rows . "</p>";
        
        if ($resultRealizadas->num_rows > 0) {
            echo "<table border='1' style='border-collapse: collapse;'>";
            echo "<tr><th>ID</th><th>Study UID</th><th>Origen</th><th>Destino</th><th>Fecha</th><th>Comentario</th></tr>";
            while ($row = $resultRealizadas->fetch_assoc()) {
                echo "<tr>";
                echo "<td>{$row['id']}</td>";
                echo "<td>" . substr($row['study_instance_uid'], 0, 30) . "...</td>";
                echo "<td>{$row['usuario_origen_nombre']}</td>";
                echo "<td>{$row['usuario_destino_nombre']}</td>";
                echo "<td>{$row['fecha_derivacion']}</td>";
                echo "<td>{$row['comentario']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "<p style='color: red;'>❌ Error en consulta: " . $conexion->error() . "</p>";
    }
    
    echo "<hr>";
    echo "<h3>4. Resumen y Recomendaciones</h3>";
    echo "<p>Si las consultas funcionan aquí pero no en admin/index.php, el problema podría estar en:</p>";
    echo "<ul>";
    echo "<li>Variables de sesión no inicializadas correctamente</li>";
    echo "<li>Conexión a base de datos diferente</li>";
    echo "<li>Errores de JavaScript que impiden mostrar los paneles</li>";
    echo "<li>CSS que oculta los elementos</li>";
    echo "</ul>";
    
    echo "<p><a href='index.php' style='background: #007bff; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;'>🔙 Volver a Admin Panel</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
} finally {
    if (isset($conexion)) {
        $conexion->cerrar();
    }
}
?>