<?php
// Parche para corregir las derivaciones en admin/index.php
// Este archivo contiene las correcciones necesarias

// INSTRUCCIONES:
// 1. Hacer backup de admin/index.php
// 2. Aplicar los cambios mostrados aquí
// 3. Probar la funcionalidad

echo "<h2>Parche para Derivaciones en Admin Panel</h2>";
echo "<p>Este archivo contiene las correcciones necesarias para admin/index.php</p>";
echo "<hr>";

echo "<h3>1. Problema Identificado</h3>";
echo "<p>Las consultas SQL en admin/index.php están correctas, pero hay problemas potenciales en:</p>";
echo "<ul>";
echo "<li>Inicialización de variables de derivaciones</li>";
echo "<li>Manejo de errores en las consultas</li>";
echo "<li>Visualización de los paneles cuando no hay datos</li>";
echo "</ul>";

echo "<h3>2. Correcciones Necesarias</h3>";

echo "<h4>A. Inicialización de Variables (líneas ~47-90)</h4>";
echo "<p><strong>CAMBIAR:</strong></p>";
echo "<pre style='background: #ffe6e6; padding: 10px;'>";
echo htmlspecialchars('
$derivacionesEnviadas = null;
$derivacionesRealizadas = null;
');
echo "</pre>";

echo "<p><strong>POR:</strong></p>";
echo "<pre style='background: #e6ffe6; padding: 10px;'>";
echo htmlspecialchars('
// Inicializar variables de derivaciones
$derivacionesEnviadas = null;
$derivacionesRealizadas = null;
$errorDerivaciones = null;
');
echo "</pre>";

echo "<h4>B. Mejora en el Manejo de Conexión (después de línea ~970)</h4>";
echo "<p><strong>AGREGAR después de la conexión:</strong></p>";
echo "<pre style='background: #e6ffe6; padding: 10px;'>";
echo htmlspecialchars('
try {
    $conexionDerivados->conectar();
    
    // Verificar que la tabla derivaciones existe
    $checkTable = "SHOW TABLES LIKE \'derivaciones\'";
    $tableExists = $conexionDerivados->query($checkTable);
    
    if (!$tableExists || $tableExists->num_rows == 0) {
        error_log(\'ADMIN: Tabla derivaciones no existe\');
        $errorDerivaciones = "Tabla de derivaciones no encontrada";
        $derivacionesEnviadas = null;
        $derivacionesRealizadas = null;
    } else {
        // Continuar con las consultas normales...
    }
} catch (Exception $e) {
    error_log(\'ADMIN: Error en conexión derivaciones: \' . $e->getMessage());
    $errorDerivaciones = $e->getMessage();
    $derivacionesEnviadas = null;
    $derivacionesRealizadas = null;
}
');
echo "</pre>";

echo "<h4>C. Mejora en las Consultas SQL (líneas ~1045-1090)</h4>";
echo "<p><strong>REEMPLAZAR las consultas existentes por:</strong></p>";
echo "<pre style='background: #e6ffe6; padding: 10px;'>";
echo htmlspecialchars('
if (!$errorDerivaciones) {
    // Consulta para derivaciones enviadas por el admin actual
    $consultaDerivacionesEnviadas = "SELECT d.id, d.study_instance_uid, d.usuario_origen_id, d.usuario_destino_id, 
                                    d.fecha_derivacion, d.activo, d.comentario, 
                                    COALESCE(d.vista, 0) as vista, COALESCE(d.descargada, 0) as descargada,
                                    d.fecha_vista, d.fecha_descarga,
                                    u.nombre as usuario_destino_nombre, u.email as usuario_destino_email 
                                    FROM derivaciones d 
                                    JOIN usuarios u ON d.usuario_destino_id = u.id 
                                    WHERE d.usuario_origen_id = $usuarioId AND d.activo = 1 
                                    ORDER BY d.fecha_derivacion DESC";
    
    $derivacionesEnviadas = $conexionDerivados->query($consultaDerivacionesEnviadas);
    
    if (!$derivacionesEnviadas) {
        error_log(\'ADMIN: Error en consulta derivaciones enviadas: \' . $conexionDerivados->error());
        $derivacionesEnviadas = null;
    } else {
        error_log(\'ADMIN: Derivaciones enviadas encontradas: \' . $derivacionesEnviadas->num_rows);
    }
    
    // Consulta para todas las derivaciones del sistema (para admin)
    $consultaDerivacionesRealizadas = "SELECT d.id, d.study_instance_uid, d.usuario_origen_id, d.usuario_destino_id, 
                                     d.fecha_derivacion, d.activo, d.comentario, 
                                     COALESCE(d.vista, 0) as vista, COALESCE(d.descargada, 0) as descargada,
                                     d.fecha_vista, d.fecha_descarga,
                                     u_origen.nombre as usuario_origen_nombre, u_origen.email as usuario_origen_email,
                                     u_destino.nombre as usuario_destino_nombre, u_destino.email as usuario_destino_email
                                     FROM derivaciones d 
                                     JOIN usuarios u_origen ON d.usuario_origen_id = u_origen.id 
                                     JOIN usuarios u_destino ON d.usuario_destino_id = u_destino.id 
                                     WHERE d.activo = 1 
                                     ORDER BY d.fecha_derivacion DESC";
    
    $derivacionesRealizadas = $conexionDerivados->query($consultaDerivacionesRealizadas);
    
    if (!$derivacionesRealizadas) {
        error_log(\'ADMIN: Error en consulta derivaciones realizadas: \' . $conexionDerivados->error());
        $derivacionesRealizadas = null;
    } else {
        error_log(\'ADMIN: Derivaciones realizadas encontradas: \' . $derivacionesRealizadas->num_rows);
    }
}
');
echo "</pre>";

echo "<h4>D. Mejora en la Visualización de Paneles (líneas ~650-750)</h4>";
echo "<p><strong>AGREGAR verificación de errores antes de mostrar paneles:</strong></p>";
echo "<pre style='background: #e6ffe6; padding: 10px;'>";
echo htmlspecialchars('
// Mostrar mensaje de error si existe
if ($errorDerivaciones) {
    echo \'<div style="background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; margin-bottom: 15px;">\'
         . \'⚠️ Error en derivaciones: \' . htmlspecialchars($errorDerivaciones) . \'</div>\';;
}

// Panel de Derivaciones (solo si no hay errores)
if (!$errorDerivaciones) {
    // ... código existente de los paneles ...
} else {
    echo \'<div style="background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin-bottom: 20px;">\'
         . \'📋 Los paneles de derivaciones no están disponibles temporalmente.</div>\';;
}
');
echo "</pre>";

echo "<h3>3. JavaScript Adicional</h3>";
echo "<p><strong>AGREGAR al final del archivo, antes de </body>:</strong></p>";
echo "<pre style='background: #e6ffe6; padding: 10px;'>";
echo htmlspecialchars('
<script>
// Función para refrescar derivaciones
function refrescarDerivaciones() {
    console.log("Refrescando derivaciones...");
    location.reload();
}

// Función para mostrar/ocultar paneles
function togglePanel(tipo) {
    const contenido = document.getElementById(\'contenido-derivaciones-\' + tipo);
    const icono = document.getElementById(\'icono-\' + tipo);
    
    if (contenido.style.maxHeight === \'0px\' || contenido.style.maxHeight === \'\') {
        contenido.style.maxHeight = \'300px\';
        icono.style.transform = \'rotate(180deg)\';
    } else {
        contenido.style.maxHeight = \'0px\';
        icono.style.transform = \'rotate(0deg)\';
    }
}

// Auto-expandir paneles si hay derivaciones
document.addEventListener(\'DOMContentLoaded\', function() {
    const contadorEnviadas = document.getElementById(\'contador-enviadas\');
    const contadorRealizadas = document.getElementById(\'contador-realizadas\');
    
    if (contadorEnviadas && parseInt(contadorEnviadas.textContent) > 0) {
        togglePanel(\'enviadas\');
    }
    
    if (contadorRealizadas && parseInt(contadorRealizadas.textContent) > 0) {
        togglePanel(\'realizadas\');
    }
});
</script>
');
echo "</pre>";

echo "<h3>4. Pasos para Aplicar el Parche</h3>";
echo "<ol>";
echo "<li>Hacer backup de <code>admin/index.php</code></li>";
echo "<li>Aplicar los cambios mostrados arriba</li>";
echo "<li>Ejecutar <a href='fix_derivaciones.php'>fix_derivaciones.php</a> para crear/poblar la tabla</li>";
echo "<li>Probar la funcionalidad en <a href='index.php'>admin/index.php</a></li>";
echo "<li>Verificar logs de error en el servidor</li>";
echo "</ol>";

echo "<h3>5. Verificación</h3>";
echo "<p>Después de aplicar los cambios:</p>";
echo "<ul>";
echo "<li>Los paneles deben mostrar contadores correctos</li>";
echo "<li>Las derivaciones deben aparecer al expandir los paneles</li>";
echo "<li>Los logs deben mostrar el número de derivaciones encontradas</li>";
echo "<li>No debe haber errores de JavaScript en la consola</li>";
echo "</ul>";

echo "<p style='margin-top: 30px;'>";
echo "<a href='index.php' style='background: #007bff; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>🔙 Volver a Admin Panel</a>";
echo "<a href='fix_derivaciones.php' style='background: #28a745; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;'>🔧 Ejecutar Fix</a>";
echo "</p>";
?>