<?php
require_once 'config/config.php';
require_once 'includes/orthanc-api.php';
require_once 'includes/functions.php';

// Datos de prueba
$studyId = '89a8e54f-7a85f78e-ff895e51-cfffae47-0e5fe905';
$patientName = 'CABRERA^CESAR IVAN';
$studyDate = '20250408';

// Construir URL de prueba usando la URL pública
$testUrl = ORTHANC_PUBLIC_HOST . "/studies/{$studyId}/archive?study={$studyId}";

echo "URL de prueba: " . $testUrl . "\n\n";

// Configurar cURL con opciones mejoradas para conexión a internet
$ch = curl_init($testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // Habilitar verificación SSL
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // Verificación estricta del host
curl_setopt($ch, CURLOPT_TIMEOUT, 300);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($ch, CURLOPT_BUFFERSIZE, 128);
curl_setopt($ch, CURLOPT_NOPROGRESS, false);
curl_setopt($ch, CURLOPT_VERBOSE, true);
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1); // Forzar HTTP/1.1
curl_setopt($ch, CURLOPT_ENCODING, ''); // Aceptar cualquier codificación
curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); // Forzar IPv4

if (defined('ORTHANC_USERNAME') && defined('ORTHANC_PASSWORD')) {
    curl_setopt($ch, CURLOPT_USERPWD, ORTHANC_USERNAME . ':' . ORTHANC_PASSWORD);
}

// Configurar logging verbose
$verbose = fopen('php://temp', 'w+');
curl_setopt($ch, CURLOPT_STDERR, $verbose);

// Ejecutar prueba
$startTime = microtime(true);
$response = curl_exec($ch);
$endTime = microtime(true);

$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
$info = curl_getinfo($ch);

// Obtener log verbose
rewind($verbose);
$verboseLog = stream_get_contents($verbose);

echo "Tiempo de ejecución: " . ($endTime - $startTime) . " segundos\n";
echo "Código HTTP: " . $httpCode . "\n";
echo "Error: " . ($error ? $error : 'Ninguno') . "\n";
echo "Tamaño de respuesta: " . strlen($response) . " bytes\n";
echo "Información de cURL:\n";
print_r($info);
echo "\nLog verbose:\n";
echo $verboseLog;

curl_close($ch);
fclose($verbose);
?> 