<?php
require_once 'config/config.php';
require_once 'includes/orthanc-api.php';
require_once 'includes/functions.php';

// Activar reporte de errores para depuración
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar sesión y permisos
session_start();

// Permitir acceso tanto a pacientes como a médicos
if (!isset($_SESSION['paciente_actual']) && !isset($_SESSION['user_id'])) {
    die("Acceso no autorizado");
}

$instanceId = $_GET['instance_id'] ?? null;

if (!$instanceId) {
    die("ID de instancia no proporcionado");
}

// Obtener detalles de la instancia para el nombre del paciente
$instanceDetails = getInstanceDetails($instanceId);
if (isset($instanceDetails['error'])) {
    die("Error al obtener detalles de la instancia: " . $instanceDetails['error']);
}

// Obtener el nombre del paciente
$patientName = $instanceDetails['PatientMainDicomTags']['PatientName'] ?? 'paciente';
$patientName = extractFirstName($patientName);
$safePatientName = preg_replace('/[^a-zA-Z0-9_-]/', '', str_replace(' ', '_', $patientName));

// Descargar el PDF de la instancia
$downloadUrl = ORTHANC_LOCAL_HOST . "/instances/{$instanceId}/pdf";
$ch = curl_init($downloadUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

// Agregar autenticación
if (defined('ORTHANC_USERNAME') && defined('ORTHANC_PASSWORD')) {
    curl_setopt($ch, CURLOPT_USERPWD, ORTHANC_USERNAME . ':' . ORTHANC_PASSWORD);
}

$pdfContent = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if ($httpCode !== 200) {
    $error = curl_error($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);
    
    error_log("Error al obtener PDF. Código: $httpCode, Error: $error");
    error_log("Información de cURL: " . print_r($info, true));
    
    die("Error al obtener el PDF (Código: $httpCode): " . $error);
}

if (empty($pdfContent)) {
    curl_close($ch);
    die("El PDF está vacío o no se pudo obtener el contenido");
}

// Establecer encabezados para descarga
header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="' . $safePatientName . '.pdf"');
header('Content-Length: ' . strlen($pdfContent));
header('Cache-Control: private, max-age=0, must-revalidate');

// Imprimir contenido del PDF
echo $pdfContent;

curl_close($ch);
exit;
?>