document.addEventListener('DOMContentLoaded', function() {
    // Manejar botones de visualización
    document.querySelectorAll('.view-btn').forEach(button => {
        button.addEventListener('click', function() {
            const studyId = this.dataset.studyId;
            const isReport = this.dataset.isReport === 'true';
            
            if (isReport) {
                // Si es un informe, abrir en una nueva pestaña
                window.open(`view-report.php?study_id=${studyId}`, '_blank');
            } else {
                // Si es un estudio de imágenes, abrir en el visor stone
                const estudio = estudiosData.find(e => e.ID === studyId);
                if (!estudio || !estudio.MainDicomTags || !estudio.MainDicomTags.StudyInstanceUID) {
                    console.error('No se pudo encontrar el StudyInstanceUID para el estudio:', studyId);
                    return;
                }
                window.open(`${ORTHANC_PUBLIC_HOST}/stone-webviewer/index.html?study=${estudio.MainDicomTags.StudyInstanceUID}`, '_blank');
            }
        });
    });

    // Manejar botones de descarga
    document.querySelectorAll('.download-btn').forEach(button => {
        button.addEventListener('click', function() {
            const studyId = this.dataset.studyId;
            const patientName = this.dataset.patientName;
            const studyDate = this.dataset.studyDate;
            const isReport = this.dataset.isReport === 'true';
            
            if (isReport) {
                // Si es un informe, descargar PDF
                window.location.href = `download-report.php?study_id=${studyId}`;
            } else {
                // Si es un estudio de imágenes, descargar DICOM
                window.location.href = `download.php?study_id=${studyId}&patient_name=${encodeURIComponent(patientName)}&study_date=${studyDate}`;
            }
        });
    });

    // Manejar toggles de descripción
    document.querySelectorAll('.description-toggle').forEach(toggle => {
        toggle.addEventListener('click', function() {
            const targetId = this.dataset.target;
            const description = document.getElementById(targetId);
            
            if (description.style.display === 'none' || !description.style.display) {
                description.style.display = 'block';
                this.textContent = 'Ver menos';
            } else {
                description.style.display = 'none';
                this.textContent = 'Ver más';
            }
        });
    });
}); 