document.addEventListener('DOMContentLoaded', function() {
    // Attach event listeners
    const viewButtons = document.querySelectorAll('.view-btn');
    const downloadButtons = document.querySelectorAll('.download-btn');

    viewButtons.forEach(button => {
        button.addEventListener('click', function() {
            const studyId = this.getAttribute('data-study-id');
            const isReport = this.getAttribute('data-is-report') === 'true';
            
            if (isReport) {
                viewReport(studyId);
            } else {
                viewStudy(studyId);
            }
        });
    });

    downloadButtons.forEach(button => {
        button.addEventListener('click', function() {
            const studyId = this.getAttribute('data-study-id');
            const patientName = this.getAttribute('data-patient-name');
            const studyDate = this.getAttribute('data-study-date');
            const isReport = this.getAttribute('data-is-report') === 'true';
            
            if (isReport) {
                downloadReport(studyId, patientName, studyDate);
            } else {
                downloadStudy(studyId, patientName, studyDate);
            }
        });
    });
});

function viewStudy(studyId) {
    // URL del visor osimis para index.php
    const viewerUrl = `${ORTHANC_PUBLIC_HOST}/osimis-viewer/app/index.html?study=${studyId}`;
    
    // Abrir el estudio en una nueva pestaña
    window.open(viewerUrl, '_blank');
}

function viewReport(studyId) {
    // Usar el visor de informes PDF personalizado
    const viewerUrl = `view-report.php?id=${studyId}`;
    
    // Abrir el informe en una nueva pestaña
    window.location.href = viewerUrl;
}

function downloadStudy(studyId, patientName, studyDate) {
    // Usar el endpoint PHP para manejar la descarga con nombre personalizado
    const downloadUrl = `download.php?id=${studyId}&name=${encodeURIComponent(patientName)}&date=${studyDate}`;
    
    // Iniciar descarga
    window.location.href = downloadUrl;
}

function downloadReport(studyId, patientName, studyDate) {
    // Usar el endpoint PHP para manejar la descarga del PDF
    const downloadUrl = `download-report.php?id=${studyId}&name=${encodeURIComponent(patientName)}&date=${studyDate}`;
    
    // Iniciar descarga
    window.location.href = downloadUrl;
}

function toggleTermsCheckbox() {
    const checkbox = document.getElementById('aceptoTerminos');
    const submitBtn = document.querySelector('.submit-btn');
    submitBtn.disabled = !checkbox.checked;
}
// Función para manejar el toggle de la descripción
document.addEventListener('DOMContentLoaded', function() {
    // Funcionalidad para mostrar/ocultar descripciones completas
    const toggleButtons = document.querySelectorAll('.description-toggle');
    
    toggleButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetId = this.getAttribute('data-target');
            const descriptionElement = document.getElementById(targetId);
            
            if (descriptionElement.style.display === 'block') {
                descriptionElement.style.display = 'none';
                this.textContent = 'Ver más';
            } else {
                descriptionElement.style.display = 'block';
                this.textContent = 'Ver menos';
            }
        });
    });
    
    // Asegurar que los botones de acción funcionen también en las tarjetas móviles
    function attachButtonListeners() {
        const allViewButtons = document.querySelectorAll('.view-btn');
        const allDownloadButtons = document.querySelectorAll('.download-btn');
        
        allViewButtons.forEach(button => {
            if (!button.hasAttribute('data-listener-attached')) {
                button.setAttribute('data-listener-attached', 'true');
                button.addEventListener('click', function() {
                    const studyId = this.getAttribute('data-study-id');
                    const isReport = this.getAttribute('data-is-report') === 'true';
                    
                    if (isReport) {
                        viewReport(studyId);
                    } else {
                        viewStudy(studyId);
                    }
                });
            }
        });
        
        allDownloadButtons.forEach(button => {
            if (!button.hasAttribute('data-listener-attached')) {
                button.setAttribute('data-listener-attached', 'true');
                button.addEventListener('click', function() {
                    const studyId = this.getAttribute('data-study-id');
                    const patientName = this.getAttribute('data-patient-name');
                    const studyDate = this.getAttribute('data-study-date');
                    const isReport = this.getAttribute('data-is-report') === 'true';
                    
                    if (isReport) {
                        downloadReport(studyId, patientName, studyDate);
                    } else {
                        downloadStudy(studyId, patientName, studyDate);
                    }
                });
            }
        });
    }
    
    // Asegurar que los botones tengan event listeners
    attachButtonListeners();
});