<?php
require_once 'config/config.php';
require_once 'includes/orthanc-api.php';
require_once 'includes/functions.php';

// Verificar sesión y permisos
session_start();

if (!isset($_SESSION['paciente_actual'])) {
    die("Acceso no autorizado");
}

$studyId = $_GET['id'] ?? null;
$patientName = $_GET['name'] ?? 'paciente';
$studyDate = $_GET['date'] ?? date('Ymd');
$modality = $_GET['modality'] ?? '';

if (!$studyId) {
    die("ID de estudio no proporcionado");
}

// Sanitizar el nombre del paciente para usarlo en el nombre de archivo
$safePatientName = preg_replace('/[^a-zA-Z0-9_-]/', '', str_replace(' ', '_', $patientName));

// Formatear fecha para el nombre de archivo
$formattedDate = $studyDate;
if (strlen($studyDate) === 8) {
    $formattedDate = substr($studyDate, 6, 2) . '-' . substr($studyDate, 4, 2) . '-' . substr($studyDate, 0, 4);
}

// Crear nombre de archivo incluyendo la modalidad
$filename = "estudio-{$formattedDate}_{$safePatientName}" . ($modality ? "_{$modality}" : "") . ".zip";

// Construir la URL de descarga directa
$downloadUrl = ORTHANC_PUBLIC_HOST . "/studies/{$studyId}/archive?filename=" . $filename;

// Establecer encabezados para descarga
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Location: ' . $downloadUrl);
exit;