<?php
session_start();

require_once 'config/config.php';
require_once 'includes/functions.php';
require_once 'includes/orthanc-api.php';

// Verificar sesión
if (!isset($_SESSION['paciente_actual'])) {
    die("Acceso no autorizado");
}

$studyId = $_GET['study_id'] ?? '';

if (empty($studyId)) {
    die("ID de estudio no proporcionado");
}

// Mostrar información html básica
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Depuración de Modalidad</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        h1 { color: #333; }
        .back-btn { 
            background-color: #0077b6; 
            color: white; 
            padding: 8px 15px; 
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <h1>Depuración de Modalidad</h1>
    <a href="index.php" class="back-btn">Volver</a>
    
    <?php
    // Llamar a la función de depuración
    debugSeriesModality($studyId);
    ?>
</body>
</html>
