<?php
session_start();

require_once 'config/config.php';
require_once 'includes/functions.php';
require_once 'includes/orthanc-api.php';

$estudios = [];
$mostrarEstudios = false;
$mensajeError = "";
$nombrePaciente = "";

// Verifica si estamos regresando del visor de informes
if (isset($_GET['action']) && $_GET['action'] === 'showResults') {
    // Verificar si hay datos en la sesión
    if (isset($_SESSION['estudios']) && isset($_SESSION['paciente_actual']) && isset($_SESSION['nombre_paciente'])) {
        $estudios = $_SESSION['estudios'];
        $nombrePaciente = $_SESSION['nombre_paciente'];
        $mostrarEstudios = true;
    }
}
// Procesar el formulario POST
else if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['aceptoTerminos'])) {
        $mensajeError = "Debe aceptar los términos y condiciones para continuar.";
    } else {
        $patId = sanitizeInput($_POST['documento']);
        $estudios = findStudiesByPatientId($patId);
        
        if (isset($estudios['error'])) {
            $mensajeError = $estudios['error'];
        } elseif (!empty($estudios)) {
            $mostrarEstudios = true;
            $_SESSION['paciente_actual'] = $patId;
            
            // Filtrar estudios para obtener solo los que no son informes o son informes PDF
            $estudiosFiltrados = [];
            foreach ($estudios as $estudio) {
                $studyDesc = $estudio['MainDicomTags']['StudyDescription'] ?? '';
                $modality = getStudyMainModality($estudio['ID']);
                
                // Si es un informe PDF o no es un informe, lo incluimos
                if (stripos($studyDesc, 'INFORME PDF') !== false || 
                    (stripos($studyDesc, 'INFORME') === false && $modality !== 'OT')) {
                    $estudiosFiltrados[] = $estudio;
                }
            }
            
            $estudios = $estudiosFiltrados;
            
            // Obtener el nombre del paciente del primer estudio que no sea un informe (modalidad OT)
            foreach ($estudios as $estudio) {
                $modality = getStudyMainModality($estudio['ID']);
                if (isset($estudio['PatientMainDicomTags']['PatientName']) && $modality !== 'OT') {
                    $nombrePaciente = extractFirstName($estudio['PatientMainDicomTags']['PatientName']);
                    break;
                }
            }
            
            // Si no se encontró un estudio no-informe, usar el primer estudio disponible
            if (empty($nombrePaciente)) {
                foreach ($estudios as $estudio) {
                    if (isset($estudio['PatientMainDicomTags']['PatientName'])) {
                        $nombrePaciente = extractFirstName($estudio['PatientMainDicomTags']['PatientName']);
                        break;
                    }
                }
            }
            
            // Guardar los datos en la sesión para poder volver a mostrarlos sin reenviar el formulario
            $_SESSION['estudios'] = $estudios;
            $_SESSION['nombre_paciente'] = $nombrePaciente;
        } else {
            $mensajeError = "No se encontraron estudios para este paciente.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal de Imágenes</title>
    <link rel="stylesheet" href="css/styles.css">
    <style>
        .full-width {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Logo centralizado en la parte superior -->
        <div class="logo-container">
            <img src="images/imac_logo.png" alt="IMAC Tucumán" class="header-logo">
        </div>

        <?php if (!$mostrarEstudios): ?>
            <div class="access-options">
                <div class="access-option full-width">
                    <h2>Acceso Paciente</h2>
                    <div class="popup">
                        <div class="popup-header">
                            <div class="popup-title">Portal de Imágenes</div>
                        </div>
                        
                        <?php if (!empty($mensajeError)): ?>
                        <div class="error-message">
                            <?php echo $mensajeError; ?>
                        </div>
                        <?php endif; ?>
                        
                        <form method="post">
                            <div class="form-group">
                                <p>Ingresa tu número de documento y visualiza tu último estudio:</p>
                                <input type="tel" name="documento" class="form-input" placeholder="Tu Número de Documento *" required pattern="[0-9]*" inputmode="numeric">
                            </div>
                            
                            <div class="terms-checkbox">
                                <input type="checkbox" name="aceptoTerminos" id="aceptoTerminos" onchange="toggleTermsCheckbox()">
                                <label for="aceptoTerminos">Acepto los <a href="#" class="terms-link">Términos y Condiciones</a></label>
                            </div>
                            
                            <div class="submit-container">
                                <button type="submit" class="submit-btn" disabled>Visualizar mi Estudio</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="estudios-container">
                <div class="estudios-header">
                    <img src="images/imac_logo.png" alt="IMAC Tucumán" class="results-logo">
                    <div class="welcome-message">
                        Hola <?php echo sanitizeInput($nombrePaciente); ?>, estos son tus estudios e informes
                    </div>
                    <button class="close-btn" onclick="window.location.href='index.php'">Cerrar</button>
                </div>
                
                <div class="estudios-content">
                    <?php if (empty($estudios)): ?>
                        <p>No se encontraron estudios para este paciente.</p>
                    <?php else: ?>
                        <!-- Vista móvil -->
                        <div class="mobile-cards-container">
                            <?php foreach ($estudios as $estudio): 
                                $mainTags = $estudio['MainDicomTags'] ?? [];
                                $studyDate = $mainTags['StudyDate'] ?? '';
                                $studyDesc = $mainTags['StudyDescription'] ?? '';
                                $studyId = $estudio['ID'] ?? '';
                                
                                // Obtener la modalidad de la primera serie
                                $modality = getStudyMainModality($studyId);
                                
                                // Determinar si es un informe
                                $isReport = false;
                                if (stripos($studyDesc, 'INFORME') !== false || $modality === 'OT') {
                                    $isReport = true;
                                }
                            ?>
                            <div class="estudio-card">
                                <div class="estudio-card-title"><?php echo getTipoEstudio($modality); ?></div>
                                
                                <div class="estudio-card-details">
                                    <div class="estudio-card-row">
                                        <span class="estudio-card-label">Fecha:</span>
                                        <span class="estudio-card-value"><?php echo formatStudyDate($studyDate); ?></span>
                                    </div>
                                    
                                    <?php if (!empty($studyDesc)): ?>
                                    <div class="estudio-card-row">
                                        <span class="estudio-card-label">Detalle:</span>
                                        <span class="estudio-card-value estudio-desc-short">
                                            <?php 
                                            $shortDesc = (strlen($studyDesc) > 40) ? substr($studyDesc, 0, 37) . '...' : $studyDesc;
                                            echo sanitizeInput($shortDesc); 
                                            ?>
                                        </span>
                                    </div>
                                    <?php if (strlen($studyDesc) > 40): ?>
                                    <span class="description-toggle" data-target="desc-<?php echo $studyId; ?>">Ver más</span>
                                    <div id="desc-<?php echo $studyId; ?>" class="estudio-card-description">
                                        <?php echo sanitizeInput($studyDesc); ?>
                                    </div>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="estudio-card-actions">
                                    <button class="action-btn view-btn" 
                                            data-study-id="<?php echo $studyId; ?>"
                                            data-is-report="<?php echo $isReport ? 'true' : 'false'; ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                            <circle cx="12" cy="12" r="3"></circle>
                                        </svg>
                                        <span class="btn-text">VISUALIZAR</span>
                                    </button>
                                    <button class="action-btn download-btn" 
                                            data-study-id="<?php echo $studyId; ?>"
                                            data-patient-name="<?php echo sanitizeInput($estudio['PatientMainDicomTags']['PatientName'] ?? 'paciente'); ?>"
                                            data-study-date="<?php echo $mainTags['StudyDate'] ?? date('Ymd'); ?>"
                                            data-is-report="<?php echo $isReport ? 'true' : 'false'; ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                                            <polyline points="7 10 12 15 17 10"></polyline>
                                            <line x1="12" y1="15" x2="12" y2="3"></line>
                                        </svg>
                                        <span class="btn-text">DESCARGA</span>
                                    </button>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <!-- Vista desktop -->
                        <div class="table-responsive desktop-view">
                            <table class="estudios-table">
                                <thead>
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Tipo de Estudio</th>
                                        <th>Descripción</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($estudios as $estudio): 
                                        $mainTags = $estudio['MainDicomTags'] ?? [];
                                        $studyDate = $mainTags['StudyDate'] ?? '';
                                        $studyDesc = $mainTags['StudyDescription'] ?? '';
                                        $studyId = $estudio['ID'] ?? '';
                                        
                                        // Obtener la modalidad de la primera serie
                                        $modality = getStudyMainModality($studyId);
                                        
                                        // Determinar si es un informe basado en StudyDescription
                                        $isReport = false;
                                        if (stripos($studyDesc, 'INFORME') !== false) {
                                            $isReport = true;
                                        }
                                        
                                        // Si encontramos una modalidad OT, es un informe
                                        if ($modality === 'OT') {
                                            $isReport = true;
                                        }
                                    ?>
                                    <tr>
                                        <td><?php echo formatStudyDate($studyDate); ?></td>
                                        <td><?php echo getTipoEstudio($modality); ?></td>
                                        <td><?php echo sanitizeInput($studyDesc); ?></td>
                                        <td>
                                            <button class="action-btn view-btn" 
                                                    data-study-id="<?php echo $studyId; ?>"
                                                    data-is-report="<?php echo $isReport ? 'true' : 'false'; ?>">
                                                <span class="btn-icon">👁️</span>
                                                <span class="btn-text">VISUALIZAR</span>
                                            </button>
                                            <button class="action-btn download-btn" 
                                                    data-study-id="<?php echo $studyId; ?>"
                                                    data-patient-name="<?php echo sanitizeInput($estudio['PatientMainDicomTags']['PatientName'] ?? 'paciente'); ?>"
                                                    data-study-date="<?php echo $mainTags['StudyDate'] ?? date('Ymd'); ?>"
                                                    data-is-report="<?php echo $isReport ? 'true' : 'false'; ?>">
                                                <span class="btn-icon">⬇️</span>
                                                <span class="btn-text">DESCARGA</span>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        // Definir la variable ORTHANC_PUBLIC_HOST para JavaScript
        const ORTHANC_PUBLIC_HOST = '<?php echo ORTHANC_PUBLIC_HOST; ?>';
    </script>
    <script src="js/main.js"></script>
</body>
</html>
