<?php
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function formatStudyDate($dateString) {
    if (empty($dateString)) return '';
    
    $year = substr($dateString, 0, 4);
    $month = substr($dateString, 4, 2);
    $day = substr($dateString, 6, 2);
    
    return "$day/$month/$year";
}

function extractFirstName($fullName) {
    // Reemplazar el carácter ^ con un espacio
    $name = str_replace('^', ' ', $fullName);
    // Eliminar espacios extra y trim
    return trim(preg_replace('/\s+/', ' ', $name));
}

function getTipoEstudio($modality) {
    $modality = trim($modality);
    
    // Mapeando modalidades según los requerimientos
    $studyTypes = [
        'CT' => 'TOMOGRAFÍA',
        'MR' => 'RESONANCIA MAGNÉTICA',
        'DX' => 'RADIOLOGÍA',
        'CR' => 'RADIOLOGÍA',
        'MG' => 'MAMOGRAFÍA',
        'MG,SR' => 'MAMOGRAFIA',
        'US' => 'ECOGRAFÍA',
        'OT' => 'INFORME de Estudio',
        'SR' => 'INFORME'	
    ];
    
    return $studyTypes[$modality] ?? strtoupper($modality);
}

function checkSession() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit();
    }
}
?>
