<?php
require_once 'config/config.php';
require_once 'includes/orthanc-api.php';
require_once 'includes/functions.php';

// Verificar sesión y permisos
session_start();

// Permitir acceso tanto a pacientes como a médicos
if (!isset($_SESSION['paciente_actual']) && !isset($_SESSION['user_id'])) {
    die("Acceso no autorizado");
}

$studyId = $_GET['id'] ?? null;
$patientName = $_GET['name'] ?? 'paciente';
$studyDate = $_GET['date'] ?? date('Ymd');

if (!$studyId) {
    die("ID de estudio no proporcionado");
}

// Sanitizar el nombre del paciente para usarlo en el nombre de archivo
$safePatientName = preg_replace('/[^a-zA-Z0-9_-]/', '', str_replace(' ', '_', $patientName));

// Formatear fecha para el nombre de archivo
$formattedDate = $studyDate;
if (strlen($studyDate) === 8) {
    $formattedDate = substr($studyDate, 6, 2) . '-' . substr($studyDate, 4, 2) . '-' . substr($studyDate, 0, 4);
}

// PASO 1: Obtener detalles del estudio para identificar el ID de serie
$url = ORTHANC_HOST . '/studies/' . $studyId;
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Agregar autenticación - Usando CURLOPT_USERPWD que es más confiable
if (defined('ORTHANC_USERNAME') && defined('ORTHANC_PASSWORD')) {
    curl_setopt($ch, CURLOPT_USERPWD, ORTHANC_USERNAME . ':' . ORTHANC_PASSWORD);
}

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if ($httpCode !== 200) {
    die("Error al obtener detalles del estudio (Código: $httpCode): " . curl_error($ch));
}

$studyDetails = json_decode($response, true);
if (empty($studyDetails) || !isset($studyDetails['Series']) || empty($studyDetails['Series'])) {
    die("No se encontraron series en el estudio o formato de respuesta inválido");
}

// PASO 2: Buscar serie que corresponde al informe
$reportSeriesId = null;

foreach ($studyDetails['Series'] as $seriesId) {
    // Obtener detalles de la serie
    $seriesUrl = ORTHANC_HOST . '/series/' . $seriesId;
    curl_setopt($ch, CURLOPT_URL, $seriesUrl);
    $seriesResponse = curl_exec($ch);
    
    if (curl_errno($ch)) {
        continue; // Intentar con la siguiente serie si hay error
    }
    
    $seriesDetails = json_decode($seriesResponse, true);
    
    // Verificar si es una serie de informe
    if (isset($seriesDetails['MainDicomTags']['SeriesDescription']) && 
        (stripos($seriesDetails['MainDicomTags']['SeriesDescription'], 'INFORME') !== false ||
         stripos($seriesDetails['MainDicomTags']['SeriesDescription'], 'OT') !== false)) {
        $reportSeriesId = $seriesId;
        break;
    }
    
    // Verificar también por modalidad OT
    if (isset($seriesDetails['MainDicomTags']['Modality']) && 
        $seriesDetails['MainDicomTags']['Modality'] === 'OT') {
        $reportSeriesId = $seriesId;
        break;
    }
}

if (!$reportSeriesId) {
    die("No se encontró ninguna serie de tipo informe en este estudio");
}

// PASO 3: Obtener ID de instancia de la serie del informe
$seriesUrl = ORTHANC_HOST . '/series/' . $reportSeriesId;
curl_setopt($ch, CURLOPT_URL, $seriesUrl);
$seriesResponse = curl_exec($ch);

if (curl_errno($ch)) {
    die("Error al obtener detalles de la serie: " . curl_error($ch));
}

$seriesDetails = json_decode($seriesResponse, true);

if (empty($seriesDetails) || !isset($seriesDetails['Instances']) || empty($seriesDetails['Instances'])) {
    die("No se encontraron instancias en la serie del informe");
}

// Tomamos la primera instancia (normalmente un informe solo tiene una)
$instanceId = $seriesDetails['Instances'][0];

// PASO 4: Descargar el PDF de la instancia
$downloadUrl = ORTHANC_HOST . "/instances/{$instanceId}/pdf";
curl_setopt($ch, CURLOPT_URL, $downloadUrl);
$pdfContent = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if ($httpCode !== 200) {
    die("Error al descargar el PDF (Código: $httpCode): " . curl_error($ch));
}

// Crear nombre de archivo
$filename = "informe-{$formattedDate}_{$safePatientName}.pdf";

// Establecer encabezados para descarga de PDF
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . strlen($pdfContent));
header('Cache-Control: private, max-age=0, must-revalidate');

// Imprimir contenido del PDF
echo $pdfContent;

curl_close($ch);
exit;
?>