<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

$error = '';

// Si ya está logueado como admin, redirigir a la página de administración
if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'admin') {
    header("Location: register.php?admin=1");
    exit;
}

// Procesamiento del formulario de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitizeInput($_POST['username']);
    $password = $_POST['password'];
    
    if (empty($username) || empty($password)) {
        $error = "Por favor, ingresa tu usuario y contraseña.";
    } else {
        // Conectar a la base de datos
        $conn = new mysqli(PORTAL_DB_HOST, PORTAL_DB_USERNAME, PORTAL_DB_PASSWORD, PORTAL_DB_NAME);
        
        if ($conn->connect_error) {
            $error = "Error de conexión a la base de datos: " . $conn->connect_error;
        } else {
            // Verificar credenciales
            $stmt = $conn->prepare("SELECT id, username, password, role, is_active FROM users WHERE username = ?");
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows === 1) {
                $user = $result->fetch_assoc();
                
                // Verificar si la cuenta está activa
                if ($user['is_active'] != 1) {
                    $error = "Esta cuenta ha sido desactivada. Contacta con un administrador.";
                } 
                // Verificar si es administrador
                elseif ($user['role'] !== 'admin') {
                    $error = "Acceso denegado. Esta área es solo para administradores.";
                }
                // Verificar contraseña
                elseif (password_verify($password, $user['password'])) {
                    // Iniciar sesión
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['username'] = $user['username'];
                    $_SESSION['role'] = $user['role'];
                    
                    // Actualizar último login
                    $updateStmt = $conn->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
                    $updateStmt->bind_param("i", $user['id']);
                    $updateStmt->execute();
                    $updateStmt->close();
                    
                    // Redirigir a la página de administración
                    header("Location: register.php");
                    exit;
                } else {
                    $error = "Contraseña incorrecta.";
                }
            } else {
                $error = "Usuario no encontrado.";
            }
            
            $stmt->close();
            $conn->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso Administración - Portal de Imágenes</title>
    <link rel="stylesheet" href="css/styles.css">
    <style>
        .admin-login-container {
            max-width: 400px;
            margin: 100px auto;
            padding: 30px;
            background-color: #f9f9f9;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        
        .admin-login-header {
            text-align: center;
            margin-bottom: 25px;
        }
        
        .admin-login-header h1 {
            color: #28a745;
            font-size: 24px;
        }
        
        .admin-icon {
            font-size: 48px;
            color: #28a745;
            margin-bottom: 15px;
        }
        
        .admin-form-group {
            margin-bottom: 20px;
        }
        
        .admin-form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
        }
        
        .admin-form-group input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
        }
        
        .admin-login-btn {
            background-color: #28a745;
            color: white;
            border: none;
            padding: 12px 0;
            width: 100%;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
        }
        
        .admin-login-btn:hover {
            background-color: #218838;
        }
        
        .back-link {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: #0077b6;
            text-decoration: none;
        }
        
        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="admin-login-container">
        <div class="admin-login-header">
            <div class="admin-icon">👨‍💼</div>
            <h1>Acceso a Administración</h1>
        </div>
        
        <?php if (!empty($error)): ?>
        <div class="error-message">
            <?php echo $error; ?>
        </div>
        <?php endif; ?>
        
        <form method="post">
            <div class="admin-form-group">
                <label for="username">Usuario Admin</label>
                <input type="text" id="username" name="username" required>
            </div>
            
            <div class="admin-form-group">
                <label for="password">Contraseña</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <button type="submit" class="admin-login-btn">Iniciar Sesión como Administrador</button>
        </form>
        
        <a href="register.php" class="back-link">Volver a Registro</a>
    </div>
</body>
</html> 