// Módulo de gestión de informes
const ReportsModule = {
    // Estado del editor
    editorState: {
        currentTemplate: null,
        content: '',
        isDirty: false
    },

    // Inicializar el editor
    initEditor: function() {
        // Configurar traducciones completas en español
        tinymce.addI18n('es', {
            // Acciones básicas
            'Undo': 'Deshacer',
            'Redo': 'Rehacer',
            'Cut': 'Cortar',
            'Copy': 'Copiar',
            'Paste': 'Pegar',
            'Select all': 'Seleccionar todo',
            
            // Formato de texto
            'Bold': 'Negrita',
            'Italic': 'Cursiva',
            'Underline': 'Subrayado',
            'Strikethrough': 'Tachado',
            'Superscript': 'Superíndice',
            'Subscript': 'Subíndice',
            
            // Alineación
            'Align left': 'Alinear a la izquierda',
            'Align center': 'Centrar',
            'Align right': 'Alinear a la derecha',
            'Justify': 'Justificar',
            
            // Listas
            'Bullet list': 'Lista con viñetas',
            'Numbered list': 'Lista numerada',
            'Decrease indent': 'Disminuir sangría',
            'Increase indent': 'Aumentar sangría',
            
            // Enlaces e imágenes
            'Insert/edit link': 'Insertar/editar enlace',
            'Remove link': 'Quitar enlace',
            'Insert/edit image': 'Insertar/editar imagen',
            'Insert/edit media': 'Insertar/editar multimedia',
            
            // Tablas
            'Insert table': 'Insertar tabla',
            'Table properties': 'Propiedades de tabla',
            'Delete table': 'Eliminar tabla',
            'Insert row before': 'Insertar fila antes',
            'Insert row after': 'Insertar fila después',
            'Delete row': 'Eliminar fila',
            'Insert column before': 'Insertar columna antes',
            'Insert column after': 'Insertar columna después',
            'Delete column': 'Eliminar columna',
            
            // Código y herramientas
            'Source code': 'Código fuente',
            'View': 'Ver',
            'Edit': 'Editar',
            'Tools': 'Herramientas',
            'Insert': 'Insertar',
            
            // Formatos
            'Format': 'Formato',
            'Formats': 'Formatos',
            'Paragraph': 'Párrafo',
            'Heading 1': 'Encabezado 1',
            'Heading 2': 'Encabezado 2',
            'Heading 3': 'Encabezado 3',
            'Heading 4': 'Encabezado 4',
            'Heading 5': 'Encabezado 5',
            'Heading 6': 'Encabezado 6',
            'Preformatted': 'Preformateado',
            
            // Colores y estilos
            'Text color': 'Color del texto',
            'Background color': 'Color de fondo',
            'Font Family': 'Familia de fuente',
            'Font Sizes': 'Tamaños de fuente',
            
            // Diálogos comunes
            'OK': 'Aceptar',
            'Cancel': 'Cancelar',
            'Close': 'Cerrar',
            'Save': 'Guardar',
            'Apply': 'Aplicar',
            'Yes': 'Sí',
            'No': 'No',
            
            // Mensajes
             'Rich Text Area': 'Área de texto enriquecido',
             'Press ALT-F10 for toolbar. Press ALT-0 for help': 'Presiona ALT-F10 para la barra de herramientas. Presiona ALT-0 para ayuda',
             
             // Menús principales
             'File': 'Archivo',
             'Edit': 'Editar',
             'View': 'Ver',
             'Insert': 'Insertar',
             'Format': 'Formato',
             'Tools': 'Herramientas',
             'Table': 'Tabla',
             'Help': 'Ayuda',
             
             // Submenús de Archivo
             'New document': 'Nuevo documento',
             'Print': 'Imprimir',
             
             // Submenús de Editar
             'Find and replace': 'Buscar y reemplazar',
             'Find': 'Buscar',
             'Replace': 'Reemplazar',
             'Find next': 'Buscar siguiente',
             'Find previous': 'Buscar anterior',
             'Replace all': 'Reemplazar todo',
             
             // Submenús de Ver
             'Visual aids': 'Ayudas visuales',
             'Fullscreen': 'Pantalla completa',
             'Preview': 'Vista previa',
             
             // Submenús de Insertar
             'Date/time': 'Fecha/hora',
             'Special character': 'Carácter especial',
             'Special characters': 'Caracteres especiales',
             'Horizontal line': 'Línea horizontal',
             'Page break': 'Salto de página',
             'Nonbreaking space': 'Espacio sin salto',
             'Anchor': 'Ancla',
             
             // Submenús de Formato
             'Clear formatting': 'Limpiar formato',
             'Remove format': 'Quitar formato',
             'Font family': 'Familia de fuente',
             'Font size': 'Tamaño de fuente',
             'Line height': 'Altura de línea',
             'Blocks': 'Bloques',
             'Inline': 'En línea',
             'Styles': 'Estilos',
             
             // Submenús de Herramientas
             'Spellcheck': 'Corrector ortográfico',
             'Word count': 'Contador de palabras',
             'Character count': 'Contador de caracteres',
             
             // Menús contextuales
             'Cut': 'Cortar',
             'Copy': 'Copiar',
             'Paste': 'Pegar',
             'Link': 'Enlace',
             'Open link': 'Abrir enlace',
             'Edit link': 'Editar enlace',
             'Unlink': 'Quitar enlace',
             'Image': 'Imagen',
             'Edit image': 'Editar imagen',
             
             // Estados y acciones
             'Loading...': 'Cargando...',
             'Uploading...': 'Subiendo...',
             'Upload': 'Subir',
             'Browse': 'Examinar',
             'Alternative description': 'Descripción alternativa',
             'Accessibility': 'Accesibilidad',
             
             // Elementos de formulario
             'Width': 'Ancho',
             'Height': 'Alto',
             'Title': 'Título',
             'Description': 'Descripción',
             'URL': 'URL',
             'Target': 'Destino',
             'Text': 'Texto',
             'Caption': 'Leyenda',
             'Alignment': 'Alineación',
             'Style': 'Estilo',
             'Class': 'Clase',
             'Border': 'Borde',
              'Spacing': 'Espaciado',
              'Padding': 'Relleno',
              'Margin': 'Margen',
              
              // Opciones adicionales de menús
              'Font': 'Fuente',
              'Size': 'Tamaño',
              'Color': 'Color',
              'More...': 'Más...',
              'Less...': 'Menos...',
              'None': 'Ninguno',
              'Default': 'Predeterminado',
              'Custom': 'Personalizado',
              'Auto': 'Automático',
              
              // Opciones de formato
              'Normal': 'Normal',
              'Code': 'Código',
              'Quote': 'Cita',
              'Blockquote': 'Cita en bloque',
              'Pre': 'Preformateado',
              'Address': 'Dirección',
              
              // Opciones de lista
              'Default': 'Predeterminado',
              'Circle': 'Círculo',
              'Disc': 'Disco',
              'Square': 'Cuadrado',
              'Lower Alpha': 'Alfabético minúscula',
              'Lower Greek': 'Griego minúscula',
              'Lower Roman': 'Romano minúscula',
              'Upper Alpha': 'Alfabético mayúscula',
              'Upper Roman': 'Romano mayúscula',
              
              // Opciones de tabla
              'Row': 'Fila',
              'Column': 'Columna',
              'Cell': 'Celda',
              'Header': 'Encabezado',
              'Body': 'Cuerpo',
              'Footer': 'Pie',
              'Row group': 'Grupo de filas',
              'Column group': 'Grupo de columnas',
              'Cell type': 'Tipo de celda',
              'Cell properties': 'Propiedades de celda',
              'Row properties': 'Propiedades de fila',
              'Table properties': 'Propiedades de tabla',
              'Border width': 'Ancho del borde',
              'Border style': 'Estilo del borde',
              'Border color': 'Color del borde',
              'Row type': 'Tipo de fila',
              'Scope': 'Ámbito',
              'Alignment': 'Alineación',
              'H Align': 'Alineación horizontal',
              'V Align': 'Alineación vertical',
              
              // Opciones de imagen
              'Image description': 'Descripción de imagen',
              'Image list': 'Lista de imágenes',
              'Upload image': 'Subir imagen',
              'Constrain proportions': 'Mantener proporciones',
              'General': 'General',
              'Advanced': 'Avanzado',
              
              // Opciones de enlace
              'Link list': 'Lista de enlaces',
              'Link title': 'Título del enlace',
              'New window': 'Nueva ventana',
              'Same window': 'Misma ventana',
              'Parent window': 'Ventana padre',
              'Top window': 'Ventana superior',
              
              // Mensajes de estado
              'Loading': 'Cargando',
              'Saving': 'Guardando',
              'Saved': 'Guardado',
              'Error': 'Error',
              'Success': 'Éxito',
              'Warning': 'Advertencia',
              'Information': 'Información',
              
              // Botones y acciones
              'Browse for an image': 'Buscar una imagen',
              'Drop an image here': 'Arrastra una imagen aquí',
              'Upload': 'Subir',
              'Insert': 'Insertar',
              'Update': 'Actualizar',
              'Remove': 'Quitar',
              'Delete': 'Eliminar',
              'Clear': 'Limpiar',
              'Reset': 'Restablecer',
              'Restore': 'Restaurar',
              
              // Opciones específicas de menús que faltaban
            'Print': 'Imprimir',
            'Print...': 'Imprimir...',
            'Paste as text': 'Pegar como texto',
            'Image...': 'Imagen...'
          });
        
        // Inicializar TinyMCE
        tinymce.init({
            selector: '#reportEditor',
            language: 'es',
            plugins: 'lists table link image code',
            toolbar: 'undo redo | formatselect | bold italic | alignleft aligncenter alignright | bullist numlist | link image | code',
            height: 500,

            content_langs: [
                { title: 'Español', code: 'es' },
                { title: 'English', code: 'en' }
            ],
            setup: function(editor) {
                editor.on('Change', function() {
                    ReportsModule.editorState.isDirty = true;
                    ReportsModule.editorState.content = editor.getContent();
                });
            }
        });

        // Cargar plantillas predefinidas
        this.loadTemplates();
    },

    // Plantillas dinámicas (se actualizan desde TemplateManager)
    templates: {},

    // Actualizar plantillas desde TemplateManager
    updateTemplates: function(newTemplates) {
        this.templates = newTemplates;
    },

    // Cargar plantillas disponibles
    loadTemplates: function() {
        // Las plantillas ahora se cargan desde TemplateManager
        // Este método se mantiene para compatibilidad
    },

    // Obtener contenido de plantilla
    getTemplateContent: function(templateId) {
        // Usar plantillas dinámicas del TemplateManager
        if (this.templates[templateId]) {
            return this.templates[templateId].content;
        }
        
        // Fallback a plantillas predeterminadas si no se encuentra
        const defaultTemplates = {
            rx: `<h2>INFORME RADIOGRÁFICO</h2>
<p><strong>Fecha:</strong> [FECHA]</p>
<p><strong>Paciente:</strong> [NOMBRE_PACIENTE]</p>
<p><strong>ID:</strong> [ID_PACIENTE]</p>
<hr>
<h3>TÉCNICA</h3>
<p>[DESCRIBIR_TÉCNICA]</p>
<h3>HALLAZGOS</h3>
<p>[DESCRIBIR_HALLAZGOS]</p>
<h3>IMPRESIÓN</h3>
<p>[CONCLUSIONES]</p>`,
            ct: `<h2>INFORME TOMOGRÁFICO</h2>
<p><strong>Fecha:</strong> [FECHA]</p>
<p><strong>Paciente:</strong> [NOMBRE_PACIENTE]</p>
<p><strong>ID:</strong> [ID_PACIENTE]</p>
<hr>
<h3>TÉCNICA</h3>
<p>[DESCRIBIR_TÉCNICA]</p>
<h3>HALLAZGOS</h3>
<p>[DESCRIBIR_HALLAZGOS]</p>
<h3>IMPRESIÓN</h3>
<p>[CONCLUSIONES]</p>`,
            mri: `<h2>INFORME DE RESONANCIA MAGNÉTICA</h2>
<p><strong>Fecha:</strong> [FECHA]</p>
<p><strong>Paciente:</strong> [NOMBRE_PACIENTE]</p>
<p><strong>ID:</strong> [ID_PACIENTE]</p>
<hr>
<h3>TÉCNICA</h3>
<p>[DESCRIBIR_TÉCNICA]</p>
<h3>HALLAZGOS</h3>
<p>[DESCRIBIR_HALLAZGOS]</p>
<h3>IMPRESIÓN</h3>
<p>[CONCLUSIONES]</p>`
        };
        return defaultTemplates[templateId] || '';
    },

    // Cargar plantilla seleccionada
    loadTemplate: function(templateId) {
        let content = this.getTemplateContent(templateId);
        
        // Usar TagManager para procesar todos los tags dinámicamente
        if (window.TagManager) {
            const urlParams = this.getPatientDataFromURL();
            content = this.processTagsInContent(content, urlParams);
        } else {
            // Fallback al método anterior si TagManager no está disponible
            const patientData = this.getPatientDataFromURL();
            if (patientData.patientId && patientData.patientName) {
                const currentDate = new Date().toLocaleDateString('es-ES');
                content = content.replace(/\[FECHA\]/g, currentDate);
                content = content.replace(/\[NOMBRE_PACIENTE\]/g, patientData.patientName);
                content = content.replace(/\[ID_PACIENTE\]/g, patientData.patientId);
            }
        }
        
        tinymce.get('reportEditor').setContent(content);
        this.editorState.currentTemplate = templateId;
        this.editorState.isDirty = false;
    },

    // Función para obtener datos del paciente desde la URL
    getPatientDataFromURL: function() {
        const urlParams = new URLSearchParams(window.location.search);
        return {
            patientId: urlParams.get('patientId') || '',
            patientName: urlParams.get('patientName') || '',
            modality: urlParams.get('modality') || '',
            studyDescription: urlParams.get('studyDescription') || '',
            // Agregar parámetros adicionales para compatibilidad con TagManager
            id: urlParams.get('patientId') || urlParams.get('id') || '',
            nombre: urlParams.get('patientName') || urlParams.get('nombre') || '',
            edad: urlParams.get('edad') || '',
            sexo: urlParams.get('sexo') || '',
            medico: urlParams.get('medico') || ''
        };
    },
    
    // Procesar todos los tags en el contenido usando TagManager
    processTagsInContent: function(content, urlParams) {
        if (!window.TagManager) {
            return content;
        }
        
        // Buscar todos los tags en el formato [TAG_NAME]
        const tagRegex = /\[([A-Z_]+)\]/g;
        let processedContent = content;
        let match;
        
        while ((match = tagRegex.exec(content)) !== null) {
            const tagName = match[1];
            const tagValue = window.TagManager.getTagValue(tagName, urlParams);
            
            // Reemplazar todas las ocurrencias de este tag
            const tagPattern = new RegExp(`\\[${tagName}\\]`, 'g');
            processedContent = processedContent.replace(tagPattern, tagValue);
        }
        
        return processedContent;
    },

    // Guardar informe
    saveReport: function() {
        const content = tinymce.get('reportEditor').getContent();
        // Aquí se implementará la lógica para guardar el informe
        console.log('Guardando informe:', content);
        this.editorState.isDirty = false;
    },

    // Exportar a PDF
    exportToPDF: function() {
        const content = tinymce.get('reportEditor').getContent();
        // Aquí se implementará la integración con PDFKit o html2pdf
        console.log('Exportando a PDF:', content);
    }
};