<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'OrthancClient.php';

// Verificar que se proporcione el ID del paciente
if (!isset($_GET['patient_id']) || empty($_GET['patient_id'])) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => 'ID de paciente requerido'
    ]);
    exit;
}

$patientId = $_GET['patient_id'];

try {
    // Crear instancia del cliente Orthanc (ahora usa configuración centralizada)
    $orthancClient = new OrthancClient();
    
    // Verificar conexión
    $serverStatus = $orthancClient->getServerStatus();
    if ($serverStatus['status'] !== 'connected') {
        throw new Exception('No se puede conectar al servidor Orthanc: ' . $serverStatus['message']);
    }
    
    // Buscar estudios por ID de paciente
    $studies = $orthancClient->findStudiesByPatientId($patientId);
    
    // Obtener nombre del paciente del primer estudio (si existe)
    $patientName = '';
    if (!empty($studies)) {
        $patientName = $studies[0]['patient_name'] ?? '';
    }
    
    echo json_encode([
        'success' => true,
        'data' => $studies,
        'patient_id' => $patientId,
        'patient_name' => $patientName,
        'total_studies' => count($studies),
        'server_status' => $serverStatus
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>