<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'OrthancClient.php';

try {
    $orthancClient = new OrthancClient();
    
    // Verificar conexión
    $serverStatus = $orthancClient->getServerStatus();
    if ($serverStatus['status'] !== 'connected') {
        throw new Exception('No se puede conectar al servidor Orthanc: ' . $serverStatus['message']);
    }
    
    // Obtener todos los pacientes con sus estudios
    $patients = $orthancClient->getAllPatients();
    
    // Formatear datos para el dashboard
    $formattedStudies = [];
    foreach ($patients as $patient) {
        foreach ($patient['studies'] as $study) {
            $formattedStudies[] = [
                'date' => $study['study_date'],
                'time' => $study['study_time'],
                'patient_name' => $study['patient_name'],
                'patient_id' => $study['patient_id'],
                'modality' => $study['modality'],
                'study_description' => $study['study_description'],
                'status' => 'Completado', // Por defecto, se puede mejorar
                'orthanc_study_id' => $study['orthanc_id'],
                'viewer_url' => $study['viewer_url'],
                'accession_number' => $study['accession_number'],
                'referring_physician' => $study['referring_physician']
            ];
        }
    }
    
    // Ordenar por fecha descendente
    usort($formattedStudies, function($a, $b) {
        return strcmp($b['date'], $a['date']);
    });
    
    echo json_encode([
        'success' => true,
        'data' => $formattedStudies,
        'total_studies' => count($formattedStudies),
        'server_status' => $serverStatus
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>