<?php
/**
 * Configuración del servidor Orthanc
 * Este archivo contiene todas las configuraciones necesarias para conectar con Orthanc
 */

class OrthancConfig {
    // Configuración del servidor Orthanc
    private static $config = [
        'server' => [
            'host' => '192.168.0.22',
            'port' => 8044,
            'protocol' => 'http', // http o https
            'username' => 'orthanc',
            'password' => 'orthanc'
        ],
        'viewer' => [
            'url' => 'https://demoportal.tanjousoft.com.ar/u-dicom-viewer/?studyId=',
            'study_id_param' => 'studyId'
        ],
        'api' => [
            'timeout' => 60,  // Aumentado a 60 segundos
            'connect_timeout' => 10,  // Timeout de conexión
            'verify_ssl' => false
        ]
    ];
    
    /**
     * Obtiene la configuración completa
     */
    public static function getConfig() {
        return self::$config;
    }
    
    /**
     * Obtiene la URL base del servidor Orthanc
     */
    public static function getServerUrl() {
        $config = self::$config['server'];
        return $config['protocol'] . '://' . $config['host'] . ':' . $config['port'];
    }
    
    /**
     * Obtiene las credenciales de autenticación
     */
    public static function getCredentials() {
        return [
            'username' => self::$config['server']['username'],
            'password' => self::$config['server']['password']
        ];
    }
    
    /**
     * Obtiene la URL del visor con el ID del estudio
     */
    public static function getViewerUrl($studyId) {
        return self::$config['viewer']['url'] . $studyId;
    }
    
    /**
     * Actualiza la configuración (para futuras implementaciones de panel de admin)
     */
    public static function updateConfig($newConfig) {
        self::$config = array_merge_recursive(self::$config, $newConfig);
        // Aquí se podría implementar la persistencia en base de datos o archivo
    }
    
    /**
     * Valida la conexión con Orthanc
     */
    public static function testConnection() {
        try {
            $url = self::getServerUrl() . '/system';
            $credentials = self::getCredentials();
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, $credentials['username'] . ':' . $credentials['password']);
            curl_setopt($ch, CURLOPT_TIMEOUT, self::$config['api']['timeout']);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, self::$config['api']['verify_ssl']);
            
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            return $httpCode === 200;
        } catch (Exception $e) {
            return false;
        }
    }
}
?>
